/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioListener;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.vo.ConnectStatVo;
import org.tio.core.stat.vo.MessageStatVo;
import org.tio.core.stat.vo.NodeStatVo;
import org.tio.core.stat.vo.StatVo;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.timer.TimerTaskService;

public class TioServerConfig
extends TioConfig {
    private final AcceptCompletionHandler acceptCompletionHandler;
    private final TioServerHandler tioServerHandler;
    private final TioServerListener tioServerListener;
    private int backlog = 1024;
    private float heartbeatBackoff = 1.0f;
    private boolean needCheckHeartbeat = true;
    private boolean isShared = false;
    private boolean proxyProtocolOn = false;
    private TimerTaskService taskService;

    public TioServerConfig(TioServerHandler tioServerHandler, TioServerListener tioServerListener) {
        this(null, tioServerHandler, tioServerListener);
    }

    public TioServerConfig(String name, TioServerHandler tioServerHandler, TioServerListener tioServerListener) {
        this(name, tioServerHandler, tioServerListener, null, null);
    }

    public TioServerConfig(TioServerHandler tioServerHandler, TioServerListener tioServerListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this(null, tioServerHandler, tioServerListener, tioExecutor, groupExecutor);
    }

    public TioServerConfig(String name, TioServerHandler tioServerHandler, TioServerListener tioServerListener, SynThreadPoolExecutor tioExecutor, ExecutorService groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.name = name;
        this.groupStat = new ServerGroupStat();
        this.acceptCompletionHandler = new AcceptCompletionHandler();
        this.tioServerHandler = tioServerHandler;
        this.tioServerListener = tioServerListener;
    }

    public void useSsl(String keyStoreFile, String keyStorePwd, ClientAuth clientAuth) {
        if (StrUtil.isNotBlank((CharSequence)keyStoreFile)) {
            this.setSslConfig(SslConfig.forServer(keyStoreFile, keyStorePwd, clientAuth));
        }
    }

    public void useSsl(String keyStoreFile, String keyStorePwd) {
        if (StrUtil.isNotBlank((CharSequence)keyStoreFile)) {
            SslConfig sslConfig = SslConfig.forServer(keyStoreFile, keyStorePwd);
            this.setSslConfig(sslConfig);
        }
    }

    public void useSsl(InputStream keyStoreInputStream, String keyStorePwd) {
        this.setSslConfig(SslConfig.forServer(keyStoreInputStream, keyStorePwd));
    }

    public void useSsl(InputStream keyStoreInputStream, String keyStorePwd, ClientAuth clientAuth) {
        this.setSslConfig(SslConfig.forServer(keyStoreInputStream, keyStorePwd, clientAuth));
    }

    public AcceptCompletionHandler getAcceptCompletionHandler() {
        return this.acceptCompletionHandler;
    }

    @Override
    public TioHandler getTioHandler() {
        return this.getTioServerHandler();
    }

    @Override
    public TioListener getTioListener() {
        return this.getTioServerListener();
    }

    public TioServerHandler getTioServerHandler() {
        return this.tioServerHandler;
    }

    public TioServerListener getTioServerListener() {
        return this.tioServerListener;
    }

    public boolean isProxyProtocolEnabled() {
        return this.proxyProtocolOn;
    }

    public void enableProxyProtocol() {
        this.enableProxyProtocol(true);
    }

    public void enableProxyProtocol(boolean enable) {
        this.proxyProtocolOn = enable;
    }

    public TimerTaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TimerTaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public float getHeartbeatBackoff() {
        return this.heartbeatBackoff;
    }

    public void setHeartbeatBackoff(float heartbeatBackoff) {
        if ((double)heartbeatBackoff < 0.5) {
            throw new IllegalArgumentException("keepalive backoff must greater than 0.5");
        }
        this.heartbeatBackoff = heartbeatBackoff;
    }

    public boolean isNeedCheckHeartbeat() {
        return this.needCheckHeartbeat;
    }

    @Override
    public StatVo getStat() {
        StatVo statVo = new StatVo();
        ServerGroupStat groupStat = (ServerGroupStat)this.groupStat;
        ConnectStatVo connections = new ConnectStatVo();
        connections.setAccepted(groupStat.accepted.sum());
        connections.setSize(Tio.getAll(this).size());
        connections.setClosed(groupStat.closed.sum());
        statVo.setConnections(connections);
        MessageStatVo messages = new MessageStatVo();
        messages.setHandledPackets(groupStat.handledPackets.sum());
        messages.setHandledBytes(groupStat.handledBytes.sum());
        messages.setReceivedPackets(groupStat.receivedPackets.sum());
        messages.setReceivedBytes(groupStat.receivedBytes.sum());
        messages.setSendPackets(groupStat.sentPackets.sum());
        messages.setSendBytes(groupStat.sentBytes.sum());
        messages.setPacketsPerTcpReceive(groupStat.getPacketsPerTcpReceive());
        messages.setBytesPerTcpReceive(groupStat.getBytesPerTcpReceive());
        statVo.setMessages(messages);
        NodeStatVo nodes = new NodeStatVo();
        nodes.setClientNodes(this.clientNodes.size());
        nodes.setConnections(this.connections.size());
        nodes.setUsers(this.users.size());
        statVo.setNodes(nodes);
        return statVo;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "TioServerConfig [name=" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void share(TioServerConfig tioConfig) {
        Class<TioServerConfig> clazz = TioServerConfig.class;
        synchronized (TioServerConfig.class) {
            if (tioConfig == this) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.clientNodes = tioConfig.clientNodes;
            this.connections = tioConfig.connections;
            this.groups = tioConfig.groups;
            this.groupStat = tioConfig.groupStat;
            this.users = tioConfig.users;
            this.tokens = tioConfig.tokens;
            this.ids = tioConfig.ids;
            this.bsIds = tioConfig.bsIds;
            if (!tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (!tioConfig.isShared && this.isShared) {
                tioConfig.needCheckHeartbeat = false;
            }
            tioConfig.isShared = true;
            this.isShared = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

