/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.stream;

import java.util.HashMap;
import java.util.Objects;
import net.dreamlu.mica.redis.stream.RStreamTemplate;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.convert.RedisCustomConversions;

public class DefaultRStreamTemplate
implements RStreamTemplate {
    private static final RedisCustomConversions customConversions = new RedisCustomConversions();
    private final StreamOperations<String, String, Object> streamOperations;

    public DefaultRStreamTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.streamOperations = redisTemplate.opsForStream();
    }

    @Override
    public RecordId send(Record<String, ?> record) {
        if (record instanceof MapRecord) {
            return this.streamOperations.add(record);
        }
        String stream = (String)Objects.requireNonNull(record.getStream(), "RStreamTemplate send stream name is null.");
        Object recordValue = Objects.requireNonNull(record.getValue(), "RStreamTemplate send stream: " + stream + " value is null.");
        Class<?> valueClass = recordValue.getClass();
        if (customConversions.isSimpleType(valueClass)) {
            return this.streamOperations.add(record);
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("@payload", recordValue);
        MapRecord mapRecord = MapRecord.create((Object)stream, payload);
        return this.streamOperations.add(mapRecord);
    }

    @Override
    public Long delete(String name, String ... recordIds) {
        return this.streamOperations.delete((Object)name, recordIds);
    }

    @Override
    public Long delete(String name, RecordId ... recordIds) {
        return this.streamOperations.delete((Object)name, recordIds);
    }

    @Override
    public Long trim(String name, long count, boolean approximateTrimming) {
        return this.streamOperations.trim((Object)name, count, approximateTrimming);
    }
}

