/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileWriteTool
implements Tool {
    @Override
    public String getName() {
        return "fromjson";
    }

    @Override
    public String getShortDescription() {
        return "Reads JSON records and writes an Avro data file.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        OptionSpec<String> codec = Util.compressionCodecOption(p);
        OptionSpec<Integer> level = Util.compressionLevelOption(p);
        ArgumentAcceptingOptionSpec<String> file = p.accepts("schema-file", "Schema File").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> inschema = p.accepts("schema", "Schema").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        List<String> nargs = opts.nonOptionArguments();
        if (nargs.size() != 1) {
            err.println("Expected 1 arg: input_file");
            p.printHelpOn(err);
            return 1;
        }
        String schemastr = (String)inschema.value(opts);
        String schemafile = (String)file.value(opts);
        if (schemastr == null && schemafile == null) {
            err.println("Need an input schema file (--schema-file) or inline schema (--schema)");
            p.printHelpOn(err);
            return 1;
        }
        Schema schema = schemafile != null ? new Schema.Parser().parse(Util.openFromFS(schemafile)) : new Schema.Parser().parse(schemastr);
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
        BufferedInputStream input = Util.fileOrStdin(nargs.get(0), stdin);
        try {
            DataInputStream din = new DataInputStream(input);
            DataFileWriter writer = new DataFileWriter(new GenericDatumWriter());
            writer.setCodec(Util.codecFactory(opts, codec, level, "null"));
            writer.create(schema, out);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, din);
            while (true) {
                Object datum;
                try {
                    datum = reader.read(null, decoder);
                }
                catch (EOFException e) {
                    break;
                }
                writer.append(datum);
            }
            writer.close();
        }
        finally {
            Util.close(input);
        }
        return 0;
    }
}

