/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

public class SaslRpcServer {
    public static final Log LOG = LogFactory.getLog(SaslRpcServer.class);
    public static final String SASL_DEFAULT_REALM = "default";
    public static final Map<String, String> SASL_PROPS = new TreeMap<String, String>();
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public static void init(Configuration conf) {
        QualityOfProtection saslQOP = QualityOfProtection.AUTHENTICATION;
        String rpcProtection = conf.get("hadoop.rpc.protection", QualityOfProtection.AUTHENTICATION.name().toLowerCase());
        if (QualityOfProtection.INTEGRITY.name().toLowerCase().equals(rpcProtection)) {
            saslQOP = QualityOfProtection.INTEGRITY;
        } else if (QualityOfProtection.PRIVACY.name().toLowerCase().equals(rpcProtection)) {
            saslQOP = QualityOfProtection.PRIVACY;
        }
        SASL_PROPS.put("javax.security.sasl.qop", saslQOP.getSaslQop());
        SASL_PROPS.put("javax.security.sasl.server.authentication", "true");
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier));
    }

    static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = SaslRpcServer.decodeIdentifier(id);
        T tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields(new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause(e);
        }
        return tokenIdentifier;
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password)).toCharArray();
    }

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    public static class SaslGssCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL server GSSAPI callback: setting canonicalized client ID: " + authzid);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private SecretManager<TokenIdentifier> secretManager;
        private Server.Connection connection;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, Server.Connection connection) {
            this.secretManager = secretManager;
            this.connection = connection;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken {
            return SaslRpcServer.encodePassword(this.secretManager.retrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = SaslRpcServer.getIdentifier(nc.getDefaultName(), this.secretManager);
                char[] password = this.getPassword(tokenIdentifier);
                UserGroupInformation user = null;
                this.connection.attemptingUser = user = tokenIdentifier.getUser();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser());
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        String username = SaslRpcServer.getIdentifier(authzid, this.secretManager).getUser().getUserName();
                        LOG.debug("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    public static enum AuthMethod {
        SIMPLE(80, "", UserGroupInformation.AuthenticationMethod.SIMPLE),
        KERBEROS(81, "GSSAPI", UserGroupInformation.AuthenticationMethod.KERBEROS),
        DIGEST(82, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.TOKEN);

        public final byte code;
        public final String mechanismName;
        public final UserGroupInformation.AuthenticationMethod authenticationMethod;
        private static final int FIRST_CODE;

        private AuthMethod(byte code, String mechanismName, UserGroupInformation.AuthenticationMethod authMethod) {
            this.code = code;
            this.mechanismName = mechanismName;
            this.authenticationMethod = authMethod;
        }

        private static AuthMethod valueOf(byte code) {
            int i = (code & 0xFF) - FIRST_CODE;
            return i < 0 || i >= AuthMethod.values().length ? null : AuthMethod.values()[i];
        }

        public String getMechanismName() {
            return this.mechanismName;
        }

        public static AuthMethod read(DataInput in) throws IOException {
            return AuthMethod.valueOf(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.code);
        }

        static {
            FIRST_CODE = AuthMethod.values()[0].code;
        }
    }

    public static enum SaslStatus {
        SUCCESS(0),
        ERROR(1);

        public final int state;

        private SaslStatus(int state) {
            this.state = state;
        }
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

