/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class AesGcmContentDecryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentDecryptionAlgorithm {
    public AesGcmContentDecryptionAlgorithm(ContentAlgorithm supportedAlgo) {
        super(supportedAlgo);
    }

    @Override
    public byte[] getEncryptedSequence(JweHeaders headers, byte[] cipher, byte[] authTag) {
        String algo = headers.getContentEncryptionAlgorithm().getJwaName();
        if (!AlgorithmUtils.isAesGcm(algo) || !this.getAlgorithm().getJwaName().equals(algo)) {
            LOG.warning("Invalid content encryption algorithm");
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        return JweCompactConsumer.getCipherWithAuthTag(cipher, authTag);
    }
}

