/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsCompactConsumer.class);
    private JsonMapObjectReaderWriter reader;
    private String encodedSequence;
    private String encodedSignature;
    private String headersJson;
    private String decodedJwsPayload;

    public JwsCompactConsumer(String encodedJws) {
        this(encodedJws, null, null);
    }

    public JwsCompactConsumer(String encodedJws, String encodedDetachedPayload) {
        this(encodedJws, encodedDetachedPayload, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JwsCompactConsumer(String encodedJws, String encodedDetachedPayload, JsonMapObjectReaderWriter r) {
        String[] parts;
        block6: {
            this.reader = new JsonMapObjectReaderWriter();
            if (r != null) {
                this.reader = r;
            }
            if ((parts = JoseUtils.getCompactParts(encodedJws)).length != 3) {
                if (parts.length == 2 && encodedJws.endsWith(".")) {
                    this.encodedSignature = "";
                    break block6;
                } else {
                    LOG.warning("Compact JWS does not have 3 parts");
                    throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
                }
            }
            this.encodedSignature = parts[2];
        }
        String encodedJwsPayload = parts[1];
        if (encodedDetachedPayload != null) {
            if (!StringUtils.isEmpty((String)encodedJwsPayload)) {
                LOG.warning("Compact JWS includes a payload expected to be detached");
                throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
            }
            encodedJwsPayload = encodedDetachedPayload;
        }
        this.encodedSequence = parts[0] + "." + encodedJwsPayload;
        this.headersJson = JoseUtils.decodeToString(parts[0]);
        this.decodedJwsPayload = JoseUtils.decodeToString(encodedJwsPayload);
    }

    public String getUnsignedEncodedSequence() {
        return this.encodedSequence;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public String getDecodedJwsPayload() {
        return this.decodedJwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.decodedJwsPayload);
    }

    public byte[] getDecodedSignature() {
        return this.encodedSignature.isEmpty() ? new byte[]{} : JoseUtils.decode(this.encodedSignature);
    }

    public JwsHeaders getJwsHeaders() {
        JsonMapObject joseHeaders = this.reader.fromJsonToJsonObject(this.headersJson);
        if (joseHeaders.getUpdateCount() != null) {
            LOG.warning("Duplicate headers have been detected");
            throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
        }
        return new JwsHeaders(joseHeaders.asMap());
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getJwsHeaders(), this.getUnsignedEncodedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (JwsException jwsException) {
            // empty catch block
        }
        LOG.warning("Invalid Signature");
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(JsonWebKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(X509Certificate cert, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(cert, algo));
    }

    public boolean verifySignatureWith(PublicKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean validateCriticalHeaders() {
        return JwsUtils.validateCriticalHeaders(this.getJwsHeaders());
    }

    protected JsonMapObjectReaderWriter getReader() {
        return this.reader;
    }
}

