/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlOutInterceptor;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlHeaderOutInterceptor
extends AbstractSamlOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlHeaderOutInterceptor.class);

    public void handleMessage(Message message) throws Fault {
        try {
            Element samlToken = (Element)message.getContextualProperty("rs-security.saml.token.element");
            SamlAssertionWrapper assertionWrapper = samlToken != null ? new SamlAssertionWrapper(samlToken) : this.createAssertion(message);
            Document doc = DOMUtils.newDocument();
            Element assertionElement = assertionWrapper.toDOM(doc);
            String encodedToken = this.encodeToken(DOM2Writer.nodeToString((Node)assertionElement));
            Map<String, List<String>> headers = this.getHeaders(message);
            StringBuilder builder = new StringBuilder();
            builder.append("SAML").append(" ").append(encodedToken);
            headers.put("Authorization", CastUtils.cast(Collections.singletonList(builder.toString()), String.class));
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    private Map<String, List<String>> getHeaders(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }
}

