/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;

public class CacheListener
implements DataListener {
    private static final int MIN_PATH_DEPTH = 5;
    private Map<String, Set<ConfigurationListener>> keyListeners = new ConcurrentHashMap<String, Set<ConfigurationListener>>();
    private CountDownLatch initializedLatch;
    private String rootPath;

    public CacheListener(String rootPath, CountDownLatch initializedLatch) {
        this.rootPath = rootPath;
        this.initializedLatch = initializedLatch;
    }

    public void addListener(String key, ConfigurationListener configurationListener) {
        Set listeners = this.keyListeners.computeIfAbsent(key, k -> new CopyOnWriteArraySet());
        listeners.add(configurationListener);
    }

    public void removeListener(String key, ConfigurationListener configurationListener) {
        Set<ConfigurationListener> listeners = this.keyListeners.get(key);
        if (listeners != null) {
            listeners.remove(configurationListener);
        }
    }

    private String pathToKey(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return path;
        }
        String groupKey = path.replace(this.rootPath + "/", "").replaceAll("/", ".");
        return groupKey.substring(groupKey.indexOf(".") + 1);
    }

    public void dataChanged(String path, Object value, EventType eventType) {
        if (eventType == null) {
            return;
        }
        if (eventType == EventType.INITIALIZED) {
            this.initializedLatch.countDown();
            return;
        }
        if (path == null || value == null && eventType != EventType.NodeDeleted) {
            return;
        }
        if (path.split("/").length >= 5) {
            ConfigChangeType changeType;
            String key = this.pathToKey(path);
            switch (eventType) {
                case NodeCreated: {
                    changeType = ConfigChangeType.ADDED;
                    break;
                }
                case NodeDeleted: {
                    changeType = ConfigChangeType.DELETED;
                    break;
                }
                case NodeDataChanged: {
                    changeType = ConfigChangeType.MODIFIED;
                    break;
                }
                default: {
                    return;
                }
            }
            ConfigChangeEvent configChangeEvent = new ConfigChangeEvent(key, (String)value, changeType);
            Set<ConfigurationListener> listeners = this.keyListeners.get(path);
            if (CollectionUtils.isNotEmpty(listeners)) {
                listeners.forEach(listener -> listener.process(configChangeEvent));
            }
        }
    }
}

