/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.selector;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.selector.ServiceInstanceSelector;

public class RandomServiceInstanceSelector
implements ServiceInstanceSelector {
    @Override
    public ServiceInstance select(URL registryURL, List<ServiceInstance> serviceInstances) {
        int size = serviceInstances.size();
        if (size < 1) {
            return null;
        }
        int index = size == 1 ? 0 : this.selectIndexRandomly(size);
        return serviceInstances.get(index);
    }

    protected int selectIndexRandomly(int size) {
        return ThreadLocalRandom.current().nextInt(size);
    }
}

