/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class AwaitingNonWebApplicationListener
implements SmartApplicationListener {
    private static final String[] WEB_APPLICATION_CONTEXT_CLASSES = new String[]{"org.springframework.web.context.WebApplicationContext", "org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext"};
    private static final Logger logger = LoggerFactory.getLogger(AwaitingNonWebApplicationListener.class);
    private static final Class<? extends ApplicationEvent>[] SUPPORTED_APPLICATION_EVENTS = AwaitingNonWebApplicationListener.of(ApplicationReadyEvent.class, ContextClosedEvent.class);
    private static final AtomicBoolean awaited = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    private static <T> T[] of(T ... values) {
        return values;
    }

    static AtomicBoolean getAwaited() {
        return awaited;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ObjectUtils.containsElement((Object[])SUPPORTED_APPLICATION_EVENTS, eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.onApplicationReadyEvent((ApplicationReadyEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void onApplicationReadyEvent(ApplicationReadyEvent event) {
        SpringApplication springApplication = event.getSpringApplication();
        if (AwaitingNonWebApplicationListener.isWebApplication((ApplicationContext)event.getApplicationContext(), springApplication.getClassLoader())) {
            return;
        }
        this.await();
    }

    private static boolean isWebApplication(ApplicationContext applicationContext, ClassLoader classLoader) {
        boolean webApplication = false;
        for (String contextClass : WEB_APPLICATION_CONTEXT_CLASSES) {
            if (!AwaitingNonWebApplicationListener.isAssignable(contextClass, applicationContext.getClass(), classLoader)) continue;
            webApplication = true;
            break;
        }
        return webApplication;
    }

    private static boolean isAssignable(String target, Class<?> type, ClassLoader classLoader) {
        try {
            return ClassUtils.resolveClassName((String)target, (ClassLoader)classLoader).isAssignableFrom(type);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    protected void onContextClosedEvent(ContextClosedEvent event) {
        this.release();
        this.shutdown();
    }

    protected void await() {
        if (awaited.get()) {
            return;
        }
        this.executorService.execute(() -> this.executeMutually(() -> {
            while (!awaited.get()) {
                if (logger.isInfoEnabled()) {
                    logger.info(" [Dubbo] Current Spring Boot Application is await...");
                }
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
    }

    protected void release() {
        this.executeMutually(() -> {
            while (awaited.compareAndSet(false, true)) {
                if (logger.isInfoEnabled()) {
                    logger.info(" [Dubbo] Current Spring Boot Application is about to shutdown...");
                }
                this.condition.signalAll();
            }
        });
    }

    private void shutdown() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

