/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;

class FsDatasetAsyncDiskService {
    public static final Log LOG = LogFactory.getLog(FsDatasetAsyncDiskService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 4;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final DataNode datanode;
    private Map<File, ThreadPoolExecutor> executors = new HashMap<File, ThreadPoolExecutor>();

    FsDatasetAsyncDiskService(DataNode datanode, File[] volumes) {
        this.datanode = datanode;
        final ThreadGroup threadGroup = new ThreadGroup(this.getClass().getSimpleName());
        for (int v = 0; v < volumes.length; ++v) {
            final File vol = volumes[v];
            ThreadFactory threadFactory = new ThreadFactory(){
                int counter = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Thread newThread(Runnable r) {
                    int thisIndex;
                    1 var3_2 = this;
                    synchronized (var3_2) {
                        thisIndex = this.counter++;
                    }
                    Thread t = new Thread(threadGroup, r);
                    t.setName("Async disk worker #" + thisIndex + " for volume " + vol);
                    return t;
                }
            };
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            executor.allowCoreThreadTimeOut(true);
            this.executors.put(vol, executor);
        }
    }

    synchronized long countPendingDeletions() {
        long count = 0L;
        for (ThreadPoolExecutor exec : this.executors.values()) {
            count += exec.getTaskCount() - exec.getCompletedTaskCount();
        }
        return count;
    }

    synchronized void execute(File root, Runnable task) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncDiskService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(root);
        if (executor == null) {
            throw new RuntimeException("Cannot find root " + root + " for execution of task " + task);
        }
        executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executors == null) {
            LOG.warn((Object)"AsyncDiskService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async disk service threads");
            for (Map.Entry<File, ThreadPoolExecutor> e : this.executors.entrySet()) {
                e.getValue().shutdown();
            }
            this.executors = null;
            LOG.info((Object)"All async disk service threads have been shut down");
        }
    }

    void deleteAsync(FsVolumeImpl volume, File blockFile, File metaFile, ExtendedBlock block, String trashDirectory) {
        LOG.info((Object)("Scheduling " + block.getLocalBlock() + " file " + blockFile + " for deletion"));
        ReplicaFileDeleteTask deletionTask = new ReplicaFileDeleteTask(volume, blockFile, metaFile, block, trashDirectory);
        this.execute(volume.getCurrentDir(), deletionTask);
    }

    class ReplicaFileDeleteTask
    implements Runnable {
        final FsVolumeImpl volume;
        final File blockFile;
        final File metaFile;
        final ExtendedBlock block;
        final String trashDirectory;

        ReplicaFileDeleteTask(FsVolumeImpl volume, File blockFile, File metaFile, ExtendedBlock block, String trashDirectory) {
            this.volume = volume;
            this.blockFile = blockFile;
            this.metaFile = metaFile;
            this.block = block;
            this.trashDirectory = trashDirectory;
        }

        public String toString() {
            return "deletion of block " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock() + " with block file " + this.blockFile + " and meta file " + this.metaFile + " from volume " + this.volume;
        }

        private boolean deleteFiles() {
            return this.blockFile.delete() && (this.metaFile.delete() || !this.metaFile.exists());
        }

        private boolean moveFiles() {
            File trashDirFile = new File(this.trashDirectory);
            if (!trashDirFile.exists() && !trashDirFile.mkdirs()) {
                LOG.error((Object)("Failed to create trash directory " + this.trashDirectory));
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Moving files " + this.blockFile.getName() + " and " + this.metaFile.getName() + " to trash."));
            }
            File newBlockFile = new File(this.trashDirectory, this.blockFile.getName());
            File newMetaFile = new File(this.trashDirectory, this.metaFile.getName());
            return this.blockFile.renameTo(newBlockFile) && this.metaFile.renameTo(newMetaFile);
        }

        @Override
        public void run() {
            boolean result;
            long dfsBytes = this.blockFile.length() + this.metaFile.length();
            boolean bl = result = this.trashDirectory == null ? this.deleteFiles() : this.moveFiles();
            if (!result) {
                LOG.warn((Object)("Unexpected error trying to " + (this.trashDirectory == null ? "delete" : "move") + " block " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock() + " at file " + this.blockFile + ". Ignored."));
            } else {
                if (this.block.getLocalBlock().getNumBytes() != Long.MAX_VALUE) {
                    FsDatasetAsyncDiskService.this.datanode.notifyNamenodeDeletedBlock(this.block, this.volume.getStorageID());
                }
                this.volume.decDfsUsed(this.block.getBlockPoolId(), dfsBytes);
                LOG.info((Object)("Deleted " + this.block.getBlockPoolId() + " " + this.block.getLocalBlock() + " file " + this.blockFile));
            }
        }
    }
}

