/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

class CSQueueUtils {
    private static final Log LOG = LogFactory.getLog(CSQueueUtils.class);
    static final float EPSILON = 1.0E-4f;

    CSQueueUtils() {
    }

    public static void checkMaxCapacity(String queueName, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queueName);
        }
    }

    public static void checkAbsoluteCapacity(String queueName, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 1.0E-4f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has " + "an absolute capacity (" + absCapacity + ") greater than " + "its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    private static void capacitiesSanityCheck(String queueName, QueueCapacities queueCapacities) {
        for (String label : queueCapacities.getExistingNodeLabels()) {
            float absMaxCapacity;
            float maximumCapacity;
            float capacity = queueCapacities.getCapacity(label);
            if (capacity > (maximumCapacity = queueCapacities.getMaximumCapacity(label))) {
                throw new IllegalArgumentException("Illegal queue capacity setting, (capacity=" + capacity + ") > (maximum-capacity=" + maximumCapacity + "). When label=[" + label + "]");
            }
            float absCapacity = queueCapacities.getAbsoluteCapacity(label);
            if (!(absCapacity > (absMaxCapacity = queueCapacities.getAbsoluteMaximumCapacity(label)))) continue;
            throw new IllegalArgumentException("Illegal queue capacity setting, (abs-capacity=" + absCapacity + ") > (abs-maximum-capacity=" + absMaxCapacity + "). When label=[" + label + "]");
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static void updateAndCheckCapacitiesByLabel(String queuePath, QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(queueCapacities, parentQueueCapacities);
        CSQueueUtils.capacitiesSanityCheck(queuePath, queueCapacities);
    }

    public static void loadUpdateAndCheckCapacities(String queuePath, CapacitySchedulerConfiguration csConf, QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        CSQueueUtils.loadCapacitiesByLabelsFromConf(queuePath, queueCapacities, csConf);
        CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(queueCapacities, parentQueueCapacities);
        CSQueueUtils.capacitiesSanityCheck(queuePath, queueCapacities);
    }

    private static void loadCapacitiesByLabelsFromConf(String queuePath, QueueCapacities queueCapacities, CapacitySchedulerConfiguration csConf) {
        queueCapacities.clearConfigurableFields();
        Set<String> configuredNodelabels = csConf.getConfiguredNodeLabels(queuePath);
        for (String label : configuredNodelabels) {
            if (label.equals("")) {
                queueCapacities.setCapacity("", csConf.getNonLabeledQueueCapacity(queuePath) / 100.0f);
                queueCapacities.setMaximumCapacity("", csConf.getNonLabeledQueueMaximumCapacity(queuePath) / 100.0f);
                continue;
            }
            queueCapacities.setCapacity(label, csConf.getLabeledQueueCapacity(queuePath, label) / 100.0f);
            queueCapacities.setMaximumCapacity(label, csConf.getLabeledQueueMaximumCapacity(queuePath, label) / 100.0f);
        }
    }

    private static void updateAbsoluteCapacitiesByNodeLabels(QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities) {
        for (String label : queueCapacities.getExistingNodeLabels()) {
            float maxCapacity;
            float capacity = queueCapacities.getCapacity(label);
            if (capacity > 0.0f) {
                queueCapacities.setAbsoluteCapacity(label, capacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteCapacity(label)));
            }
            if (!((maxCapacity = queueCapacities.getMaximumCapacity(label)) > 0.0f)) continue;
            queueCapacities.setAbsoluteMaximumCapacity(label, maxCapacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteMaximumCapacity(label)));
        }
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(ResourceCalculator calculator, CSQueue childQueue, CSQueue parentQueue, Resource clusterResource, Resource minimumAllocation) {
        Resource queueLimit = Resources.none();
        Resource usedResources = childQueue.getUsedResources();
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        if (Resources.greaterThan((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)clusterResource, (Resource)Resources.none())) {
            queueLimit = Resources.multiply((Resource)clusterResource, (double)childQueue.getAbsoluteCapacity());
            absoluteUsedCapacity = Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)clusterResource);
            usedCapacity = Resources.equals((Resource)queueLimit, (Resource)Resources.none()) ? 0.0f : Resources.divide((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)usedResources, (Resource)queueLimit);
        }
        childQueue.setUsedCapacity(usedCapacity);
        childQueue.setAbsoluteUsedCapacity(absoluteUsedCapacity);
        Resource available = Resources.subtract((Resource)queueLimit, (Resource)usedResources);
        childQueue.getMetrics().setAvailableResourcesToQueue(Resources.max((ResourceCalculator)calculator, (Resource)clusterResource, (Resource)available, (Resource)Resources.none()));
    }

    public static float getAbsoluteMaxAvailCapacity(ResourceCalculator resourceCalculator, Resource clusterResource, CSQueue queue) {
        CSQueue parent = queue.getParent();
        if (parent == null) {
            return queue.getAbsoluteMaximumCapacity();
        }
        float parentMaxAvail = CSQueueUtils.getAbsoluteMaxAvailCapacity(resourceCalculator, clusterResource, parent);
        Resource parentResource = Resources.multiply((Resource)clusterResource, (double)parentMaxAvail);
        if (Resources.isInvalidDivisor((ResourceCalculator)resourceCalculator, (Resource)parentResource)) {
            return 0.0f;
        }
        float siblingUsedCapacity = Resources.ratio((ResourceCalculator)resourceCalculator, (Resource)Resources.subtract((Resource)parent.getUsedResources(), (Resource)queue.getUsedResources()), (Resource)parentResource);
        float maxAvail = Math.min(queue.getMaximumCapacity(), 1.0f - siblingUsedCapacity);
        float absoluteMaxAvail = maxAvail * parentMaxAvail;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("qpath " + queue.getQueuePath()));
            LOG.debug((Object)("parentMaxAvail " + parentMaxAvail));
            LOG.debug((Object)("siblingUsedCapacity " + siblingUsedCapacity));
            LOG.debug((Object)("getAbsoluteMaximumCapacity " + queue.getAbsoluteMaximumCapacity()));
            LOG.debug((Object)("maxAvail " + maxAvail));
            LOG.debug((Object)("absoluteMaxAvail " + absoluteMaxAvail));
        }
        if (absoluteMaxAvail < 0.0f) {
            absoluteMaxAvail = 0.0f;
        } else if (absoluteMaxAvail > 1.0f) {
            absoluteMaxAvail = 1.0f;
        }
        return absoluteMaxAvail;
    }
}

