/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeClientIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxySpatialIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.table.Column;
import org.h2.table.IndexColumn;

class H2IndexFactory {
    private final IgniteLogger log;

    H2IndexFactory(GridKernalContext ctx) {
        this.log = ctx.log(H2IndexFactory.class);
    }

    Index createIndex(GridH2Table tbl, IndexDescriptor idxDesc) {
        Index targetIdx;
        GridCacheContextInfo cacheInfo = tbl.cacheInfo();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating H2 index [cacheId=" + cacheInfo.cacheId() + ", idxName=" + idxDesc.name() + ']');
        }
        LinkedHashMap keyDefs = idxDesc.keyDefinitions();
        ArrayList<IndexColumn> idxCols = new ArrayList<IndexColumn>(keyDefs.size());
        for (Map.Entry keyDef : keyDefs.entrySet()) {
            Column col = tbl.getColumn((String)keyDef.getKey());
            idxCols.add(tbl.indexColumn(col.getColumnId(), ((IndexKeyDefinition)keyDef.getValue()).order().sortOrder() == SortOrder.ASC ? 0 : 1));
        }
        IndexColumn[] idxColsArr = idxCols.toArray(new IndexColumn[idxCols.size()]);
        if (idxDesc.type() == QueryIndexType.SORTED) {
            InlineIndexImpl qryIdx;
            if (idxDesc.isProxy()) {
                targetIdx = tbl.getIndex(idxDesc.targetIdx().name());
                assert (targetIdx != null);
                return new GridH2ProxyIndex(tbl, idxDesc.name(), idxCols, targetIdx);
            }
            if (cacheInfo.affinityNode()) {
                qryIdx = (InlineIndexImpl)idxDesc.index().unwrap(InlineIndexImpl.class);
                return new H2TreeIndex(qryIdx, tbl, idxColsArr, idxDesc.isPk(), this.log);
            }
            qryIdx = (InlineIndex)idxDesc.index().unwrap(InlineIndex.class);
            IndexType idxType = idxDesc.isPk() ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false);
            return new H2TreeClientIndex((InlineIndex)qryIdx, tbl, idxDesc.name(), idxColsArr, idxType);
        }
        if (idxDesc.type() == QueryIndexType.GEOSPATIAL) {
            if (idxDesc.isProxy()) {
                targetIdx = tbl.getIndex(idxDesc.targetIdx().name());
                assert (targetIdx != null);
                return new GridH2ProxySpatialIndex(tbl, idxDesc.name(), idxCols, targetIdx);
            }
            return H2Utils.createSpatialIndex(tbl, idxDesc, idxCols);
        }
        throw new IllegalStateException("Index type: " + idxDesc.type());
    }
}

