/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminUtils$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.network.Processor;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\u0005ce>\\WM]%ecU\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012A\u00032s_.,'/\u001332A!9q\u0004\u0001b\u0001\n\u0003)\u0012!\u00032s_.,'/\u001333\u0011\u0019\t\u0003\u0001)A\u0005-\u0005Q!M]8lKJLEM\r\u0011\t\u000f\r\u0002!\u0019!C\u0001I\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003\u0015\u0002\"a\u0006\u0014\n\u0005\u001dB\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007S\u0001\u0001\u000b\u0011B\u0013\u00023\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000e\t\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u0011G>tg-[4Qe>\u00048/M0%KF$\"\u0001O\u001e\u0011\u0005]I\u0014B\u0001\u001e\u0019\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u0003.\u00035\u0019wN\u001c4jOB\u0013x\u000e]:2A!9\u0001\t\u0001a\u0001\n\u0003a\u0013\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004b\u0002\"\u0001\u0001\u0004%\taQ\u0001\u0011G>tg-[4Qe>\u00048OM0%KF$\"\u0001\u000f#\t\u000fq\n\u0015\u0011!a\u0001[!1a\t\u0001Q!\n5\nQbY8oM&<\u0007K]8qgJ\u0002\u0003b\u0002%\u0001\u0001\u0004%\t!S\u0001\bG>tg-[4t+\u0005Q\u0005cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005IC\u0012a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011\u0006\u0004\u0005\u0002X56\t\u0001L\u0003\u0002Z\t\u000511/\u001a:wKJL!a\u0017-\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005az\u0006b\u0002\u001f]\u0003\u0003\u0005\rA\u0013\u0005\u0007C\u0002\u0001\u000b\u0015\u0002&\u0002\u0011\r|gNZ5hg\u0002Bqa\u0019\u0001A\u0002\u0013\u0005A-A\u0004tKJ4XM]:\u0016\u0003\u0015\u00042aS*g!\t9v-\u0003\u0002i1\nY1*\u00194lCN+'O^3s\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001\b\u001c\u0005\by%\f\t\u00111\u0001f\u0011\u0019q\u0007\u0001)Q\u0005K\u0006A1/\u001a:wKJ\u001c\b\u0005C\u0004q\u0001\t\u0007I\u0011A9\u0002\rI\fg\u000eZ8n+\u0005\u0011\bCA:v\u001b\u0005!(B\u0001\u0019\u0019\u0013\t1HO\u0001\u0004SC:$w.\u001c\u0005\u0007q\u0002\u0001\u000b\u0011\u0002:\u0002\u000fI\fg\u000eZ8nA!9!\u0010\u0001b\u0001\n\u0003Y\u0018!\u0002;pa&\u001cW#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018'\u0001\u0003mC:<\u0017bAA\u0002}\n11\u000b\u001e:j]\u001eDq!a\u0002\u0001A\u0003%A0\u0001\u0004u_BL7\r\t\u0005\t\u0003\u0017\u0001!\u0019!C\u0001+\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\ty\u0001\u0001Q\u0001\nY\tA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0011\"a\u0005\u0001\u0005\u0004%\t!!\u0006\u0002\u001f-\fgm[1Ba&\u001cHj\\4hKJ,\"!a\u0006\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005)An\\45U*!\u0011\u0011EA\u0012\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u00037\u0011a\u0001T8hO\u0016\u0014\b\u0002CA\u0017\u0001\u0001\u0006I!a\u0006\u0002!-\fgm[1Ba&\u001cHj\\4hKJ\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011AA\u000b\u0003YqW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b\u0002CA\u001b\u0001\u0001\u0006I!a\u0006\u0002/9,Go^8sWB\u0013xnY3tg>\u0014Hj\\4hKJ\u0004\u0003\"CA\u001d\u0001\t\u0007I\u0011AA\u000b\u0003I\u0019\u0018P\\2Qe>$WoY3s\u0019><w-\u001a:\t\u0011\u0005u\u0002\u0001)A\u0005\u0003/\t1c]=oGB\u0013x\u000eZ;dKJdunZ4fe\u0002B\u0011\"!\u0011\u0001\u0005\u0004%\t!!\u0006\u0002%\u00154XM\u001c;IC:$G.\u001a:M_\u001e<WM\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002\u0018\u0005\u0019RM^3oi\"\u000bg\u000e\u001a7fe2{wmZ3sA!9\u0011\u0011\n\u0001\u0005B\u0005-\u0013!B:fiV\u0003H#\u0001\u001d)\t\u0005\u001d\u0013q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)!\u0011QKA\u0012\u0003\u0015QWO\\5u\u0013\u0011\tI&a\u0015\u0003\r\t+gm\u001c:f\u0011\u001d\ti\u0006\u0001C!\u0003\u0017\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u00037\n\t\u0007\u0005\u0003\u0002R\u0005\r\u0014\u0002BA3\u0003'\u0012Q!\u00114uKJDq!!\u001b\u0001\t\u0013\tY'\u0001\u0007ti\u0006\u0014HO\u0011:pW\u0016\u00148\u000fF\u00029\u0003[B\u0001\"a\u001c\u0002h\u0001\u0007\u0011\u0011O\u0001\bG2,8\u000f^3s!\rY5+\f\u0005\b\u0003k\u0002A\u0011AA&\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3)\t\u0005M\u0014\u0011\u0010\t\u0005\u0003#\nY(\u0003\u0003\u0002~\u0005M#\u0001\u0002+fgRDq!!!\u0001\t\u0003\tY%A\u0011uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G\r\u000b\u0003\u0002\u0000\u0005\u0015\u0005\u0003BA)\u0003\u000fKA!!#\u0002T\t1\u0011j\u001a8pe\u0016DC!a \u0002z!9\u0011q\u0012\u0001\u0005\u0002\u0005-\u0013a\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012\u0014\u0015\u0010V8qS\u000e|e/\u001a:sS\u0012,\u0007\u0006BAG\u0003sBq!!&\u0001\t\u0003\tY%\u0001\u0018uKN$8\t\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012\u0014\u0015\u0010V8qS\u000e|e/\u001a:sS\u0012,\u0007\u0006BAJ\u0003\u000bCC!a%\u0002z!9\u0011Q\u0014\u0001\u0005\u0002\u0005-\u0013!\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:LeN^1mS\u0012$v\u000e]5d\u001fZ,'O]5eK\"\"\u00111TA=\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u0017\n!E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007bBAT\u0001\u0011\u0005\u00111J\u0001$m\u0016\u0014\u0018NZ=V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0011\u001d\tY\u000b\u0001C\u0005\u0003[\u000bab\u001d5vi\u0012|wO\\*feZ,'\u000fF\u00029\u0003_Ca!WAU\u0001\u00041\u0007bBAZ\u0001\u0011%\u0011QW\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0003\u00028\u0006%\u0007#B&\u0002:\u0006u\u0016bAA^+\n!A*[:u!\u0011\ty,!2\u000f\u0007]\t\t-C\u0002\u0002Db\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000fT1!a1\u0019\u0011\u001dQ\u0018\u0011\u0017a\u0001\u0003{\u0003")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder().append((Object)"topic").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);
    private final Logger syncProducerLogger = Logger.getLogger(SyncProducer.class);
    private final Logger eventHandlerLogger = Logger.getLogger(DefaultEventHandler.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Logger syncProducerLogger() {
        return this.syncProducerLogger;
    }

    public Logger eventHandlerLogger() {
        return this.eventHandlerLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17()));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final Object apply(Properties configProps) {
                configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.enableControlledShutdown())).toString());
                configProps.put("controlled.shutdown.max.retries", "1");
                return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
        this.syncProducerLogger().setLevel(Level.FATAL);
        this.eventHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        this.syncProducerLogger().setLevel(Level.ERROR);
        this.eventHandlerLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(Properties props) {
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
                KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
                this.$outer.configs_$eq((Seq<KafkaConfig>)((Seq)this.$outer.configs().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{config})), Seq$.MODULE$.canBuildFrom())));
                this.$outer.servers_$eq((Seq<KafkaServer>)((Seq)this.$outer.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    @Ignore
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    @Ignore
    public void testCleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0)new Serializable(this, topicProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final Properties topicProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), this.$outer.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.$outer.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.brokerId1()})))})), this.topicProps$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicProps$1 = topicProps$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$1 = leaderId$1;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerId$1 = followerId$1;
            }
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$1 = this.zkUtils();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, x$6, (Option<Object>)x$4);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "third");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic()));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$2 = leaderId$2;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerId$2 = followerId$2;
            }
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$7 = this.zkUtils();
        String x$8 = this.topic();
        int x$9 = this.partitionId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, x$12, (Option<Object>)x$10);
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "third");
            throw this.fail("Message produced while leader is down should fail, but it succeeded", new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExecutionException && (executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic()));
                ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$2;

                    public final boolean apply(KafkaServer server) {
                        return server.config().brokerId() == this.leaderId$2;
                    }
                    {
                        this.leaderId$2 = leaderId$2;
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(KafkaServer server) {
                        server.startup();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ZkUtils x$13 = this.zkUtils();
                String x$14 = this.topic();
                int x$15 = this.partitionId();
                Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
                long x$17 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
                Option<Object> x$18 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
                TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$13, x$14, x$15, x$17, x$18, (Option<Object>)x$16);
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), null, "third");
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$2;

                    public final boolean apply(KafkaServer server) {
                        return server.config().brokerId() == this.leaderId$2;
                    }
                    {
                        this.leaderId$2 = leaderId$2;
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UncleanLeaderElectionTest $outer;

                    public final void apply(KafkaServer server) {
                        this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ZkUtils x$19 = this.zkUtils();
                String x$20 = this.topic();
                int x$21 = this.partitionId();
                Some x$22 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
                long x$23 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
                Option<Object> x$24 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
                TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$19, x$20, x$21, x$23, x$24, (Option<Object>)x$22);
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"})), this.consumeAllMessages(this.topic()));
                return;
            }
            throw throwable;
        }
    }

    public void kafka$integration$UncleanLeaderElectionTest$$shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private List<String> consumeAllMessages(String topic) {
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString(), "id", 1000L);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(new ConsumerConfig(consumerProps));
        Map messageStream = consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> messages = TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)messageStream, TestUtils$.MODULE$.getMessages$default$2());
        consumerConnector.shutdown();
        return messages;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

