/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u000f\ti\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dcU\t1\u0003\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!A.\u00198h\u0015\u0005A\u0012\u0001\u00026bm\u0006L!AG\u000b\u0003\rM#(/\u001b8h\u0011\u0019a\u0002\u0001)A\u0005'\u00059Ao\u001c9jGF\u0002\u0003b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011\u00199\u0003\u0001)A\u0005A\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003\"B\u0015\u0001\t\u0003R\u0013!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u00111F\f\t\u0003C1J!!\f\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006_!\u0002\r\u0001M\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u00195\u001b\u0005\u0011$BA\u001a\u0018\u0003\u0011)H/\u001b7\n\u0005U\u0012$A\u0003)s_B,'\u000f^5fg\")q\u0007\u0001C!q\u0005)1/\u001a;VaR\t1\u0006\u000b\u00027uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005c$A\u0002\"fM>\u0014X\rC\u0003D\u0001\u0011\u0005\u0001(\u0001\u001ftQ>,H\u000e\u001a*fG\u0016Lg/Z(qKJ\fG/[8o\u001d>$\u0018\t\u001e;f[B$X\rZ,iK:|E\u000f[3s!\u0006\u0014H/\u001b;j_:D\u0015m]#se>\u0014\bF\u0001\"F!\tYd)\u0003\u0002Hy\t!A+Z:u\u0011\u0015I\u0005\u0001\"\u0003K\u0003a\u0019XM\u001c3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d*fcV,7\u000f\u001e\u000b\u0004\u0017ZC\u0006C\u0001'U\u001b\u0005i%B\u0001(P\u0003!\u0011X-];fgR\u001c(B\u0001)R\u0003\u0019\u0019w.\\7p]*\u0011QA\u0015\u0006\u0003'z\na!\u00199bG\",\u0017BA+N\u0005i\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKN\u0004xN\\:f\u0011\u00159\u0006\n1\u0001!\u0003!aW-\u00193fe&#\u0007\"B-I\u0001\u0004Q\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\u0019nK!\u0001X'\u00033\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f\u001e\u0005\u0006=\u0002!IaX\u0001\u000eGJ,\u0017\r^3SKF,Xm\u001d;\u0015\u0005i\u0003\u0007\"B1^\u0001\u0004\u0011\u0017A\u00039beRLG/[8ogB\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002kE\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\u0011a\u0015n\u001d;\u000b\u0005)\u0014\u0003CA8q\u001b\u0005y\u0015BA9P\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004")
public class AddPartitionsToTxnRequestTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), this.numPartitions(), this.servers().size(), (Seq<KafkaServer>)this.servers(), new Properties());
    }

    @Test
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError() {
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        AddPartitionsToTxnRequest request = this.createRequest((List<TopicPartition>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{createdTopicPartition, nonExistentTopic})));
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = this.sendAddPartitionsRequest(leaderId, request);
        Assert.assertEquals((long)2L, (long)response.errors().size());
        Assert.assertTrue((boolean)response.errors().containsKey(createdTopicPartition));
        Assert.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, response.errors().get(createdTopicPartition));
        Assert.assertTrue((boolean)response.errors().containsKey(nonExistentTopic));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(nonExistentTopic));
    }

    private AddPartitionsToTxnResponse sendAddPartitionsRequest(int leaderId, AddPartitionsToTxnRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ADD_PARTITIONS_TO_TXN, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AddPartitionsToTxnResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private AddPartitionsToTxnRequest createRequest(List<TopicPartition> partitions) {
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(transactionalId, producerId, producerEpoch, JavaConversions$.MODULE$.seqAsJavaList(partitions));
        return (AddPartitionsToTxnRequest)builder.build();
    }

    public AddPartitionsToTxnRequestTest() {
        this.topic1 = "foobartopic";
        this.numPartitions = 3;
    }
}

