/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0006\u0001)Q\u0005\u007f\u0005I!p[\"mS\u0016tG\u000f\t\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000bqA_6Vi&d7/F\u0001U!\t!S+\u0003\u0002WK\t9!l[+uS2\u001c\b\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0001Z\u0003-Q8.\u0016;jYN|F%Z9\u0015\u0005)S\u0006b\u0002(X\u0003\u0003\u0005\r\u0001\u0016\u0005\u00079\u0002\u0001\u000b\u0015\u0002+\u0002\u0011i\\W\u000b^5mg\u0002BQA\u0018\u0001\u0005\u0002}\u000bQa]3u+B$\u0012A\u0013\u0015\u0003;\u0006\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u001c\u0002\u000b),h.\u001b;\n\u0005\u0019\u001c'A\u0002\"fM>\u0014X\rC\u0003i\u0001\u0011\u0005q,\u0001\u0005uK\u0006\u0014Hi\\<oQ\t9'\u000e\u0005\u0002cW&\u0011An\u0019\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006]\u0002!\taX\u0001\"i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:NCJ\\G)\u001b:fGR|'/_'baBLgn\u001a\u0015\u0003[B\u0004\"AY9\n\u0005I\u001c'\u0001\u0002+fgRDQ\u0001\u001e\u0001\u0005\u0002}\u000b\u0011\u0006^3ti\"Kw\r[<bi\u0016\u0014X*\u0019:l%\u0016d\u0017\r^5wK\u0012K'/Z2u_JLX*\u00199qS:<\u0007FA:q\u0011\u00159\b\u0001\"\u0001`\u0003]!Xm\u001d;JY2,w-\u00197SKF,\u0018N]3e\u0003\u000e\\7\u000f\u000b\u0002wa\")!\u0010\u0001C\u0001?\u0006!C/Z:u\u00072,\u0017M\u001d)ve\u001e\fGo\u001c:z\u001f:\u0014UmY8nS:<gi\u001c7m_^,'\u000f\u000b\u0002za\")Q\u0010\u0001C\u0001?\u0006AD/Z:u%\u0016\u001cW-\u001b<f\u001fV$xJZ(sI\u0016\u00148+Z9vK:\u001cW-\u0012=dKB$\u0018n\u001c8XSRDGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bF\u0001?q\u0011\u0019\t\t\u0001\u0001C\u0001?\u0006\u0011C/Z:u%\u0016\fGmQ8n[&$H/\u001a3GKR\u001c\u0007\u000eT5nSR,G-\u0011;M'>C#a 9\t\r\u0005\u001d\u0001\u0001\"\u0001`\u0003-\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00138dYV$Wm]!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\bfAA\u0003a\"1\u0011Q\u0002\u0001\u0005\u0002}\u000bq\u0006^3ti\u001a+Go\u00195CKf|g\u000e\u001a%jO\"<\u0016\r^3s[\u0006\u00148NU3ukJtW)\u001c9usJ+7\u000f]8og\u0016D3!a\u0003q\u0011\u0019\t\u0019\u0002\u0001C\u0001?\u0006yC/Z:u\r\u0016$8\r['fgN\fw-Z:XQ\u0016tgj\u001c;G_2dwn^3s\r>\u0014xJ\\3QCJ$\u0018\u000e^5p]\"\u001a\u0011\u0011\u00039\u0007\r\u0005e\u0001\u0001BA\u000e\u00059\u0019\u0015\r\u001c7cC\u000e\\'+Z:vYR,B!!\b\u0002,M\u0019\u0011q\u0003\u0005\t\u000f=\t9\u0002\"\u0001\u0002\"Q\u0011\u00111\u0005\t\u0007\u0003K\t9\"a\n\u000e\u0003\u0001\u0001B!!\u000b\u0002,1\u0001A\u0001CA\u0017\u0003/\u0011\r!a\f\u0003\u0003Q\u000bB!!\r\u00028A\u0019\u0011\"a\r\n\u0007\u0005U\"BA\u0004O_RD\u0017N\\4\u0011\u0007%\tI$C\u0002\u0002<)\u00111!\u00118z\u0011)\ty$a\u0006A\u0002\u0013%\u0011\u0011I\u0001\u0006m\u0006dW/Z\u000b\u0003\u0003\u0007\u0002R!CA#\u0003OI1!a\u0012\u000b\u0005\u0019y\u0005\u000f^5p]\"Q\u00111JA\f\u0001\u0004%I!!\u0014\u0002\u0013Y\fG.^3`I\u0015\fHc\u0001&\u0002P!Ia*!\u0013\u0002\u0002\u0003\u0007\u00111\t\u0005\n\u0003'\n9\u0002)Q\u0005\u0003\u0007\naA^1mk\u0016\u0004\u0003BCA,\u0003/\u0001\r\u0011\"\u0003\u0002Z\u0005\u0019a-\u001e8\u0016\u0005\u0005m\u0003#B\u0005\u0002F\u0005u\u0003CB\u0005\u0002`\u0005\u001d\"*C\u0002\u0002b)\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\u0005\u0015\u0014q\u0003a\u0001\n\u0013\t9'A\u0004gk:|F%Z9\u0015\u0007)\u000bI\u0007C\u0005O\u0003G\n\t\u00111\u0001\u0002\\!I\u0011QNA\fA\u0003&\u00111L\u0001\u0005MVt\u0007\u0005\u0003\u0005\u0002r\u0005]A\u0011AA:\u0003-\t7o]3si\u001aK'/\u001a3\u0016\u0005\u0005\u001d\u0002\u0002CA<\u0003/!\t!!\u001f\u0002\u000f%\u001ch)\u001b:fIV\u0011\u00111\u0010\t\u0004\u0013\u0005u\u0014bAA@\u0015\t9!i\\8mK\u0006t\u0007\u0002CAB\u0003/!\t!!\"\u0002\t\u0019L'/\u001a\u000b\u0004\u0015\u0006\u001d\u0005\u0002CA \u0003\u0003\u0003\r!a\n\t\u0011\u0005-\u0015q\u0003C\u0001\u0003\u001b\u000baa\u001c8GSJ,G\u0003BA\u0012\u0003\u001fC\u0001\"a\u0016\u0002\n\u0002\u0007\u0011Q\f\u0005\b\u0003'\u0003A\u0011BAK\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRQ\u0011qSAc\u0003\u001f\fY.a;\u0011\r\u0005\u0015\u0012qCAM!\u0011\tY*a0\u000f\t\u0005u\u0015\u0011\u0018\b\u0005\u0003?\u000b)L\u0004\u0003\u0002\"\u0006Mf\u0002BAR\u0003csA!!*\u00020:!\u0011qUAW\u001b\t\tIKC\u0002\u0002,\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005U2\u0014BA\u00035\u0013\t\u00114'C\u0002\u00028F\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003w\u000bi,A\bQe>$WoY3SKN\u0004xN\\:f\u0015\r\t9,M\u0005\u0005\u0003\u0003\f\u0019MA\tQCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016TA!a/\u0002>\"A\u0011qYAI\u0001\u0004\tI-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007I\tY-C\u0002\u0002N\n\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005\u0002R\u0006E\u0005\u0019AAj\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002V\u0006]W\"A\u0019\n\u0007\u0005e\u0017G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005u\u0017\u0011\u0013a\u0001\u0003?\fqA]3d_J$7\u000f\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)/M\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005%\u00181\u001d\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0015\u00055\u0018\u0011\u0013I\u0001\u0002\u0004\tY(\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000fC\u0004\u0002r\u0002!I!a=\u0002\u001f\u0019,Go\u00195Bg\u000e{gn];nKJ$B\"!>\u0002~\u0006}(\u0011\u0001B\n\u0005;\u0001b!!\n\u0002\u0018\u0005]\bc\u0001\n\u0002z&\u0019\u00111 \u0002\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\t\u0003\u000f\fy\u000f1\u0001\u0002J\"A\u0011\u0011[Ax\u0001\u0004\t\u0019\u000e\u0003\u0005\u0003\u0004\u0005=\b\u0019\u0001B\u0003\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!q\u0001B\u0007\u001d\u0011\tiJ!\u0003\n\t\t-\u0011QX\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005\u001f\u0011\tBA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0005\u0017\ti\f\u0003\u0006\u0003\u0016\u0005=\b\u0013!a\u0001\u0005/\t\u0001\"\\5o\u0005f$Xm\u001d\t\u0004\u0013\te\u0011b\u0001B\u000e\u0015\t\u0019\u0011J\u001c;\t\u0015\t}\u0011q\u001eI\u0001\u0002\u0004\u0011\t#\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\t\t\r\"QE\u0007\u0003\u0003{KAAa\n\u0002>\nq\u0011j]8mCRLwN\u001c'fm\u0016d\u0007b\u0002B\u0016\u0001\u0011%!QF\u0001\u0010M\u0016$8\r[!t\r>dGn\\<feRa\u0011Q\u001fB\u0018\u0005c\u0011\u0019D!\u000e\u00038!A\u0011q\u0019B\u0015\u0001\u0004\tI\r\u0003\u0005\u0002R\n%\u0002\u0019AAj\u0011!\u0011\u0019A!\u000bA\u0002\t\u0015\u0001B\u0003B\u000b\u0005S\u0001\n\u00111\u0001\u0003\u0018!Q!q\u0004B\u0015!\u0003\u0005\rA!\t\t\u000f\tm\u0002\u0001\"\u0003\u0003>\u0005ia-\u001a;dQ6+7o]1hKN$b\"!>\u0003@\t\u0005#Q\tB$\u0005\u0013\u0012Y\u0005\u0003\u0005\u0002H\ne\u0002\u0019AAe\u0011!\u0011\u0019E!\u000fA\u0002\t]\u0011!\u0003:fa2L7-Y%e\u0011!\t\tN!\u000fA\u0002\u0005M\u0007\u0002\u0003B\u0002\u0005s\u0001\rA!\u0002\t\u0011\tU!\u0011\ba\u0001\u0005/A\u0001Ba\b\u0003:\u0001\u0007!\u0011\u0005\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0003!\u001aX\r^;q%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s/&$\b.T8dW\u0016$\u0007+\u001e:hCR|'/[3t)\u0019\tIMa\u0015\u0003b!A!Q\u000bB'\u0001\u0004\u00119&A\u0003uS6,'\u000f\u0005\u0003\u0003Z\tuSB\u0001B.\u0015\r\u0011)&J\u0005\u0005\u0005?\u0012YFA\u0005N_\u000e\\G+[7fe\"Q!1\rB'!\u0003\u0005\rA!\u001a\u0002\u001d\u0005d\u0017N^3Ce>\\WM]%egB1!q\rB9\u0005/qAA!\u001b\u0003n9!\u0011q\u0015B6\u0013\u0005Y\u0011b\u0001B8\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B:\u0005k\u00121aU3r\u0015\r\u0011yG\u0003\u0005\n\u0005s\u0002\u0011\u0013!C\u0005\u0005w\nq#\u00199qK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu$\u0006BA>\u0005\u007fZ#A!!\u0011\t\t\r%QR\u0007\u0003\u0005\u000bSAAa\"\u0003\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017S\u0011AC1o]>$\u0018\r^5p]&!!q\u0012BC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005'\u0003\u0011\u0013!C\u0005\u0005+\u000b\u0011DZ3uG\"\f5oQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0013\u0016\u0005\u0005/\u0011y\bC\u0005\u0003\u001c\u0002\t\n\u0011\"\u0003\u0003\u001e\u0006Ib-\u001a;dQ\u0006\u001b8i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011yJ\u000b\u0003\u0003\"\t}\u0004\"\u0003BR\u0001E\u0005I\u0011\u0002BS\u0003I\u001aX\r^;q%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s/&$\b.T8dW\u0016$\u0007+\u001e:hCR|'/[3tI\u0011,g-Y;mi\u0012\u0012TC\u0001BTU\u0011\u0011)Ga \t\u0013\t-\u0006!%A\u0005\n\tU\u0015!\u00074fi\u000eD\u0017i\u001d$pY2|w/\u001a:%I\u00164\u0017-\u001e7uIQB\u0011Ba,\u0001#\u0003%IA!(\u00023\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$C-\u001a4bk2$H%\u000e")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private ZkUtils zkUtils;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), false));
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$5, Iterable<Partition> x$6) {
                }
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.kafka$server$ReplicaManagerTest$$appendRecords(rm, new TopicPartition(this.topic(), 0), records2, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
                }
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$7, Iterable<Partition> x$8) {
                }
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$9, Iterable<Partition> x$10) {
                }
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$1;
                private final long producerId$1;
                private final short epoch$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$1 = replicaManager$1;
                    this.producerId$1 = producerId$1;
                    this.epoch$1 = epoch$1;
                }
            });
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
                    Assert.assertEquals((long)0L, (long)response.logStartOffset);
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$11, Iterable<Partition> x$12) {
                }
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$2;
                private final long producerId$2;
                private final short epoch$2;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$2, (short)this.epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$2, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$2 = replicaManager$2;
                    this.producerId$2 = producerId$2;
                    this.epoch$2 = epoch$2;
                }
            });
            ReplicaManager x$21 = replicaManager;
            TopicPartition x$22 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$23 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000);
            IsolationLevel x$24 = IsolationLevel.READ_UNCOMMITTED;
            int x$25 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$21, x$22, x$23, x$25, x$24);
            ReplicaManager x$26 = replicaManager;
            TopicPartition x$27 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$28 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$29 = IsolationLevel.READ_COMMITTED;
            int x$30 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$26, x$27, x$28, x$30, x$29);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$31 = replicaManager;
            TopicPartition x$32 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$33 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$34 = IsolationLevel.READ_COMMITTED;
            int x$35 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$31, x$32, x$33, x$35, x$34);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer2.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$36 = replicaManager;
            TopicPartition x$37 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$38 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$39 = IsolationLevel.READ_COMMITTED;
            int x$40 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$36, x$37, x$38, x$40, x$39);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$41 = replicaManager;
            TopicPartition x$42 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$43 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$44 = IsolationLevel.READ_UNCOMMITTED;
            int x$45 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$41, x$42, x$43, x$45, x$44);
            ReplicaManager x$46 = replicaManager;
            TopicPartition x$47 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$48 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$49 = IsolationLevel.READ_COMMITTED;
            int x$50 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$46, x$47, x$48, x$50, x$49);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$13, Iterable<Partition> x$14) {
                }
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$3;
                private final long producerId$3;
                private final short epoch$3;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$3, (short)this.epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$3, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$3 = replicaManager$3;
                    this.producerId$3 = producerId$3;
                    this.epoch$3 = epoch$3;
                }
            });
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$51 = replicaManager;
            TopicPartition x$52 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$53 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$54 = IsolationLevel.READ_UNCOMMITTED;
            int x$55 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$51, x$52, x$53, x$55, x$54);
            ReplicaManager x$56 = replicaManager;
            TopicPartition x$57 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$58 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$59 = IsolationLevel.READ_COMMITTED;
            int x$60 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$56, x$57, x$58, x$60, x$59);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer2.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$15, Iterable<Partition> x$16) {
                }
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.rm$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$61 = 0;
            boolean x$62 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$61, x$62);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$63 = 0;
            boolean x$64 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$63, x$64);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$17, Iterable<Partition> x$18) {
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, replicaManager, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$4;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$4 = replicaManager$4;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            });
            long x$65 = 1000L;
            int x$66 = 1;
            int x$67 = 0;
            int x$68 = Integer.MAX_VALUE;
            boolean x$69 = false;
            Seq x$70 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000))}));
            Serializable x$71 = new Serializable(this, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.tp0$1, this.tp1$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            };
            IsolationLevel x$72 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$73 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$65, x$66, x$67, x$68, x$69, x$70, x$73, (Function1)x$71, x$72);
            Option tp0Replica = replicaManager.getReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.getReplica(tp1);
            Option tp1Replica = replicaManager.getReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    public CallbackResult<ProduceResponse.PartitionResponse> kafka$server$ReplicaManagerTest$$appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records2, boolean isFromClient) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, (short)-1, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records2)})), (Function1)new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$1;
            private final CallbackResult result$1;

            public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responses) {
                this.$outer.kafka$server$ReplicaManagerTest$$appendCallback$1(responses, this.partition$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    public boolean kafka$server$ReplicaManagerTest$$appendRecords$default$4() {
        return true;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$74 = 1000L;
        int x$75 = replicaId;
        int x$76 = minBytes;
        int x$77 = Integer.MAX_VALUE;
        boolean x$78 = false;
        Seq x$79 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Serializable x$80 = new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$2;
            private final CallbackResult result$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.partition$2, this.result$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.result$2 = result$2;
            }
        };
        IsolationLevel x$81 = isolationLevel;
        ReplicaQuota x$82 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$74, x$75, x$76, x$77, x$78, x$79, x$82, (Function1)x$80, x$81);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer2, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$20) {
                return new File(x$20);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int brokerId) {
                return TestUtils$.MODULE$.createBroker(brokerId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), brokerId, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$1;

            public final IExpectationSetters<Object> apply(int brokerId) {
                return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache$1.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
            }
            {
                this.metadataCache$1 = metadataCache$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$83 = "Produce";
        MockTimer x$84 = timer2;
        boolean x$85 = false;
        int x$86 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$87 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$88 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$83, (Timer)x$84, x$86, x$87, x$85, x$88);
        String x$89 = "Fetch";
        MockTimer x$90 = timer2;
        boolean x$91 = false;
        int x$92 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$93 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$94 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$89, (Timer)x$90, x$92, x$93, x$91, x$94);
        String x$95 = "DeleteRecords";
        MockTimer x$96 = timer2;
        boolean x$97 = false;
        int x$98 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$99 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$100 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$95, (Timer)x$96, x$98, x$99, x$97, x$100);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public final void kafka$server$ReplicaManagerTest$$appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
            Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
            result$2.fire(fetchData2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Object value$1;

                public final void apply(Function1<T, BoxedUnit> f) {
                    f.apply(this.value$1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

