/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.Serializable;
import java.util.Properties;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\u000b\u0016\u0001iAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u0001-\u0011\u0019)\u0004\u0001)A\u0005[!9a\u0007\u0001b\u0001\n\u00039\u0004B\u0002!\u0001A\u0003%\u0001\bC\u0003B\u0001\u0011\u0005!\tC\u0004V\u0001\t\u0007I\u0011\u0001\u0017\t\rY\u0003\u0001\u0015!\u0003.\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015)\u0007\u0001\"\u0001Y\u0011\u00159\u0007\u0001\"\u0001Y\u0011\u0015I\u0007\u0001\"\u0001Y\u0011\u0015Y\u0007\u0001\"\u0001Y\u0011\u0015i\u0007\u0001\"\u0001Y\u0011\u0015y\u0007\u0001\"\u0001Y\u0011\u0015\t\b\u0001\"\u0003s\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\u00111\"T3ue&\u001c7\u000fV3ti*\u0011acF\u0001\b[\u0016$(/[2t\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0018\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005\u0001j\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011:\u0012!B;uS2\u001c\u0018B\u0001\u0014$\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\u000b\u0002\u00119,XNT8eKN,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0004\u0013:$\u0018!\u00038v[:{G-Z:!\u0003!qW/\u001c)beR\u001c\u0018!\u00038v[B\u000b'\u000f^:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001B;uS2T\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@u\tQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\r\u00032\u0001\u0012'P\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I3\u00051AH]8pizJ\u0011\u0001M\u0005\u0003\u0017>\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-{\u0003C\u0001)T\u001b\u0005\t&B\u0001*\u0018\u0003\u0019\u0019XM\u001d<fe&\u0011A+\u0015\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0005o\u001b\u0016\u001c8/Y4fg\u0006Qa.T3tg\u0006<Wm\u001d\u0011\u0002KQ,7\u000f^'fiJL7m\u001d*fa>\u0014H/\u001a:BMR,'\u000fR3mKRLgn\u001a+pa&\u001cG#A-\u0011\u00059R\u0016BA.0\u0005\u0011)f.\u001b;)\u0005-i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0017aA8sO&\u0011Am\u0018\u0002\u0005)\u0016\u001cH/\u0001\u001buKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+:\u0014XmZ5ti\u0016\u0014X\rZ!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#\u0001D/\u0002'Q,7\u000f^\"mkN$XM]%e\u001b\u0016$(/[2)\u00055i\u0016\u0001\u0007;fgR<\u0016N\u001c3poN\u001cF/\u001f7f)\u0006<g*Y7fg\"\u0012a\"X\u0001!i\u0016\u001cHO\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\nKH/Z:J]>+H\u000f\u000b\u0002\u0010;\u0006)B/Z:u\u0007>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001c\bF\u0001\t^\u0003\u0001\"Xm\u001d;TKN\u001c\u0018n\u001c8FqBL'/\u001a'jgR,g.\u001a:NKR\u0014\u0018nY:)\u0005Ei\u0016AC7fi\u0016\u00148i\\;oiR\u00111O\u001e\t\u0003]QL!!^\u0018\u0003\t1{gn\u001a\u0005\u0006oJ\u0001\r\u0001_\u0001\u000b[\u0016$(/[2OC6,\u0007CA=~\u001d\tQ8\u0010\u0005\u0002G_%\u0011ApL\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}_\u0005\tBo\u001c9jG6+GO]5d\u000fJ|W\u000f]:\u0015\t\u0005\u0015\u0011\u0011\u0003\t\u0006\u0003\u000f\ti\u0001_\u0007\u0003\u0003\u0013Q1!a\u00030\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\tIAA\u0002TKRDa!a\u0005\u0014\u0001\u0004A\u0018!\u0002;pa&\u001c\u0007")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(x$2))), (long)1L);
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        long initialReplicationBytesIn = this.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = this.meterCount(replicationBytesOut);
        long initialBytesIn = this.meterCount(bytesIn);
        long initialBytesOut = this.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((this.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assert.assertEquals((long)initialBytesOut, (long)this.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages() * 2, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((this.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$1(x$5))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$2(x$6))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$3(x$7))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$4(x$8))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$5(x$9))), (long)1L);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$10))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$11))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$12))), (long)1L);
    }

    private long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$meterCount$1(metricName, x$13))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString()))).count();
    }

    private Set<String> topicMetricGroups(String topic) {
        Regex topicMetricRegex = new Regex(new StringBuilder(25).append(".*BrokerTopicMetrics.*(").append(topic).append(")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return (Set)metricGroups.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$topicMetricGroups$1(topicMetricRegex, x$14)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaServer s) {
        Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()));
        Assert.assertTrue((String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString(), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$1(MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$2(MetricName x$6) {
        String string = x$6.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$3(MetricName x$7) {
        String string = x$7.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$4(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$5(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$meterCount$1(String metricName$1, MetricName x$13) {
        return x$13.getMBeanName().endsWith(metricName$1);
    }

    public static final /* synthetic */ boolean $anonfun$topicMetricGroups$1(Regex topicMetricRegex$1, String x$14) {
        return topicMetricRegex$1.pattern().matcher(x$14).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

