/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001B\u0013'\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\bY\u0002\t\n\u0011\"\u0001n\u0011\u001dA\b!%A\u0005\u0002eDQa\u001f\u0001\u0005\u0002qD\u0001\"a\u0007\u0001#\u0003%\t!\u001f\u0005\n\u0003;\u0001\u0011\u0013!C\u0001\u0003?Aq!a\t\u0001\t\u0003\t)\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kB\u0011\"!$\u0001#\u0003%\t!a$\t\u0013\u0005M\u0005!%A\u0005\u0002\u0005U\u0005\"CAM\u0001E\u0005I\u0011AA\"\u0011\u001d\tY\n\u0001C\u0001\u0003;C\u0011\"!+\u0001#\u0003%\t!a$\t\u0013\u0005-\u0006!%A\u0005\u0002\u0005U\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005+AqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u00055\tE-\\5o5.\u001cE.[3oi*\u0011q\u0005K\u0001\u0003u.T\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UB\u0013!B;uS2\u001c\u0018BA\u001c5\u0005\u001daunZ4j]\u001e\f\u0001B_6DY&,g\u000e\u001e\t\u0003umj\u0011AJ\u0005\u0003y\u0019\u0012QbS1gW\u0006T6n\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002@\u0001B\u0011!\b\u0001\u0005\u0006q\t\u0001\r!O\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0004D\rNC&\f\u001a\t\u0003[\u0011K!!\u0012\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000f\u000e\u0001\r\u0001S\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u0013Bs!A\u0013(\u0011\u0005-sS\"\u0001'\u000b\u00055S\u0013A\u0002\u001fs_>$h(\u0003\u0002P]\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tye\u0006C\u0003U\u0007\u0001\u0007Q+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\"!\f,\n\u0005]s#aA%oi\")\u0011l\u0001a\u0001+\u0006\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000fm\u001b\u0001\u0013!a\u00019\u0006YAo\u001c9jG\u000e{gNZ5h!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0003vi&d'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d)7\u0001%AA\u0002\u0019\fQB]1dW\u0006;\u0018M]3N_\u0012,\u0007CA4k\u001b\u0005A'BA5)\u0003\u0015\tG-\\5o\u0013\tY\u0007NA\u0007SC\u000e\\\u0017i^1sK6{G-Z\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\u0005q'F\u0001/pW\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002v]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0014(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*T#\u0001>+\u0005\u0019|\u0017AE4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$R!`A\u0007\u0003\u001f\u0001RA`A\u0002\u0003\u000fi\u0011a \u0006\u0004\u0003\u0003q\u0013AC2pY2,7\r^5p]&\u0019\u0011QA@\u0003\u0007M+\u0017\u000fE\u0002h\u0003\u0013I1!a\u0003i\u00059\u0011%o\\6fe6+G/\u00193bi\u0006Dq!\u001a\u0004\u0011\u0002\u0003\u0007a\rC\u0005\u0002\u0012\u0019\u0001\n\u00111\u0001\u0002\u0014\u0005Q!M]8lKJd\u0015n\u001d;\u0011\u000b5\n)\"!\u0007\n\u0007\u0005]aF\u0001\u0004PaRLwN\u001c\t\u0005}\u0006\rQ+\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000fJ\u0019\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0005\u0016\u0004\u0003'y\u0017!G2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$\u0012bQA\u0014\u0003S\ti#a\u000e\t\u000b\u001dK\u0001\u0019\u0001%\t\r\u0005-\u0012\u00021\u0001]\u0003\u0019\u0019wN\u001c4jO\"9\u0011qF\u0005A\u0002\u0005E\u0012A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bC\u0002@\u00024U\u000bI\"C\u0002\u00026}\u00141!T1q\u0011%\tI$\u0003I\u0001\u0002\u0004\tY$\u0001\u0005wC2LG-\u0019;f!\ri\u0013QH\u0005\u0004\u0003\u007fq#a\u0002\"p_2,\u0017M\\\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t)EK\u0002\u0002<=\f1C^1mS\u0012\fG/\u001a+pa&\u001c7I]3bi\u0016$raQA&\u0003\u001b\ny\u0005C\u0003H\u0017\u0001\u0007\u0001\nC\u0004\u00020-\u0001\r!!\r\t\r\u0005-2\u00021\u0001]\u0003u9(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$HcB\"\u0002V\u0005]\u0013\u0011\u000e\u0005\u0006\u000f2\u0001\r\u0001\u0013\u0005\b\u00033b\u0001\u0019AA.\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\u0007}\u0006MR+!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019)\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0005\u0003O\n\tGA\tSKBd\u0017nY1BgNLwM\\7f]RDq!a\u001b\r\u0001\u0004\tY$\u0001\u0005jgV\u0003H-\u0019;f\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007\r\u000b\t\bC\u0003H\u001b\u0001\u0007\u0001*A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000f\u0003c\t9(!\u001f\u0002~\u0005\u0005\u0015QQAE\u0011\u00159e\u00021\u0001I\u0011\u001d\tYH\u0004a\u0001\u00037\n!#\u001a=jgRLgnZ!tg&<g.\\3oi\"1\u0011q\u0010\bA\u0002u\f!\"\u00197m\u0005J|7.\u001a:t\u0011!\t\u0019I\u0004I\u0001\u0002\u0004)\u0016!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0005\u0002Z9\u0001\n\u00111\u0001\u0002\bB)Q&!\u0006\u00022!I\u00111\u0012\b\u0011\u0002\u0003\u0007\u00111H\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!!%+\u0005U{\u0017aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t9JK\u0002\u0002\b>\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0002;\r\u0014X-\u0019;f\u001d\u0016<\b+\u0019:uSRLwN\\:BgNLwM\\7f]R$B\"a\u0017\u0002 \u0006\u0005\u00161UAS\u0003OCQa\u0012\nA\u0002!Cq!a\u001f\u0013\u0001\u0004\tY\u0006\u0003\u0004\u0002\u0000I\u0001\r! \u0005\t\u0003\u0007\u0013\u0002\u0013!a\u0001+\"I\u0011\u0011\f\n\u0011\u0002\u0003\u0007\u0011qQ\u0001(GJ,\u0017\r^3OK^\u0004\u0016M\u001d;ji&|gn]!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\u0014de\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012*\u0014AH2sK\u0006$X\rU1si&$\u0018n\u001c8t/&$\b.Q:tS\u001etW.\u001a8u)!\tY&!-\u00024\u0006U\u0006\"B$\u0016\u0001\u0004A\u0005bBA>+\u0001\u0007\u00111\f\u0005\b\u0003o+\u0002\u0019AA.\u0003YqWm\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0007<bY&$\u0017\r^3SKBd\u0017nY1BgNLwM\\7f]R$raQA_\u0003\u007f\u000b\u0019\rC\u0004\u0002ZY\u0001\r!!\r\t\r\u0005\u0005g\u00031\u0001V\u0003e)\u0007\u0010]3di\u0016$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\u0005\u0015g\u00031\u0001\u0002H\u0006\u0011\u0012M^1jY\u0006\u0014G.\u001a\"s_.,'/\u00133t!\u0011I\u0015\u0011Z+\n\u0007\u0005-'KA\u0002TKR\f1\u0002]1sg\u0016\u0014%o\\6feR!\u0011\u0011[Aj!\u0011i\u0013QC+\t\r\u0005Uw\u00031\u0001I\u0003\u0019\u0011'o\\6fe\u0006i1\r[1oO\u0016\u001cuN\u001c4jON$raQAn\u0003?\f\u0019\u000f\u0003\u0004\u0002^b\u0001\r\u0001S\u0001\u000bK:$\u0018\u000e^=UsB,\u0007BBAq1\u0001\u0007\u0001*\u0001\u0006f]RLG/\u001f(b[\u0016Da!!:\u0019\u0001\u0004a\u0016aB2p]\u001aLwm]\u0001\u0015G\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4\u0015\u000b\r\u000bY/a<\t\r\u00055\u0018\u00041\u0001I\u0003E\u0019\u0018M\\5uSj,Gm\u00117jK:$\u0018\n\u001a\u0005\u0007\u0003KL\u0002\u0019\u0001/\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<G#B\"\u0002v\u0006e\bBBA|5\u0001\u0007\u0001*A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\r\u0003\u0004\u0002fj\u0001\r\u0001X\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006\u0007\u0006}(\u0011\u0001\u0005\u0006\u000fn\u0001\r\u0001\u0013\u0005\u0007\u0003K\\\u0002\u0019\u0001/\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003D\u0005\u000f\u0011I\u0001C\u0003H9\u0001\u0007\u0001\n\u0003\u0004\u0002fr\u0001\r\u0001X\u0001\u0013G\"\fgnZ3Ce>\\WM]\"p]\u001aLw\rF\u0003D\u0005\u001f\u0011\u0019\u0002C\u0004\u0003\u0012u\u0001\r!!\u0007\u0002\u000f\t\u0014xn[3sg\"1\u0011Q]\u000fA\u0002q#Ra\u0011B\f\u00053Aq!!6\u001f\u0001\u0004\t\t\u000e\u0003\u0004\u0002fz\u0001\r\u0001X\u0001\u0015m\u0006d\u0017\u000eZ1uK\n\u0013xn[3s\u0007>tg-[4\u0015\u0007\r\u0013y\u0002\u0003\u0004\u0002f~\u0001\r\u0001X\u0001\u0013G\"\fgnZ3F]RLG/_\"p]\u001aLw\rF\u0004D\u0005K\u0011IC!\f\t\r\t\u001d\u0002\u00051\u0001I\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016DaAa\u000b!\u0001\u0004A\u0015a\u00064vY2\u001c\u0016M\\5uSj,G-\u00128uSRLh*Y7f\u0011\u0019\t)\u000f\ta\u00019\u0006\tb-\u001a;dQ\u0016sG/\u001b;z\u0007>tg-[4\u0015\u000bq\u0013\u0019D!\u000e\t\r\t\u001d\u0012\u00051\u0001I\u0011\u0019\t90\ta\u0001\u0011\u0006\u0011r-\u001a;BY2$v\u000e]5d\u0007>tg-[4t)\t\u0011Y\u0004E\u0003\u007f\u0003gAE,A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\tm\"\u0011\t\u0005\u0007\u0003;\u001c\u0003\u0019\u0001%\u00025\u0019,Go\u00195BY2\u001c\u0005.\u001b7e\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\r\tm\"q\tB%\u0011\u0019\u00119\u0003\na\u0001\u0011\"1!1\n\u0013A\u0002!\u000bqb\u00195jY\u0012,e\u000e^5usRK\b/\u001a")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, -1, -1);
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment, this.createTopicWithAssignment$default$4());
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq seq;
        void var10_9;
        None$ none$;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        if (brokerList == null) {
            throw null;
        }
        if (brokerList.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq seq2 = (Seq)brokerList.get();
            none$ = new Some((Object)AdminZkClient.$anonfun$getBrokerMetadatas$1(allBrokers, seq2));
        }
        None$ none$2 = none$;
        none$ = null;
        None$ getOrElse_this = none$2;
        if (getOrElse_this.isEmpty()) {
            Seq<Broker> seq3 = allBrokers;
        } else {
            Object object = getOrElse_this.get();
        }
        Object var9_6 = null;
        Object var10_10 = null;
        Seq seq4 = (Seq)var10_9;
        Seq brokersWithRack = (Seq)seq4.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.length() < seq4.length()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        if (RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode)) {
            seq = (Seq)seq4.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$));
            return (Seq)seq.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
        }
        if (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode)) {
            if (brokersWithRack == null) {
                throw null;
            }
            if (brokersWithRack.length() < seq4.length()) {
                seq = (Seq)seq4.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$));
                return (Seq)seq.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
            }
        }
        seq = (Seq)seq4.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()));
        return (Seq)seq.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment, boolean validate) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(58).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").toString()).append(new StringBuilder(11).append("assignment ").append(partitionReplicaAssignment).toString()).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            Seq v = (Seq)x0$1._2();
            ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq<Object>)v);
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            replicaAssignment = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })), false);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                String mkString_sep = ", ";
                Object var8_6 = null;
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString("", mkString_sep, "")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                this.zkClient.createTopicAssignment(topic, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2;
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition k = (TopicPartition)x0$2._1();
                    ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                    Seq<Object> $minus$greater$extension_y = v.replicas();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, $minus$greater$extension_y);
                    Object var4_3 = null;
                    tuple2 = null;
                    Tuple2 tuple23 = tuple22;
                    return tuple23;
                })));
            } else {
                this.zkClient.setTopicAssignment(topic, (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Updated path %s with %s for replica assignment", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension("topic %s is already marked for deletion", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment);
        if (validateOnly) {
            return (Map)((MapOps)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions)).map((Function1 & Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                Tuple2 tuple2;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                Seq<Object> seq = v.replicas();
                Integer $minus$greater$extension_$this = k;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                Object var4_4 = null;
                seq = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            });
        }
        return (Map)this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions).map((Function1 & Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
            Seq<Object> seq = v.replicas();
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            seq = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)0, (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(0).append(new StringBuilder(80).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").toString()).append(new StringBuilder(12).append("Assignment: ").append(existingAssignment).toString()).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(0).append("The number of partitions for a topic can only be increased. ").append(new StringBuilder(34).append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").toString()).append(new StringBuilder(26).append(numPartitions).append(" would not be an increase.").toString()).toString());
        }
        if (replicaAssignment == null) {
            throw null;
        }
        if (!replicaAssignment.isEmpty()) {
            Map map = (Map)replicaAssignment.get();
            AdminZkClient.$anonfun$createNewPartitionsAssignment$2(this, existingAssignmentPartition0, allBrokers, map);
        }
        Object object = replicaAssignment.isEmpty() ? AdminZkClient.$anonfun$createNewPartitionsAssignment$4(allBrokers, existingAssignmentPartition0, partitionsToAdd, existingAssignment) : replicaAssignment.get();
        Object object2 = object;
        object = null;
        return (Map)((Map)object2).map((Function1 & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            void apply_removingReplicas;
            ReplicaAssignment replicaAssignment;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tp = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Nil$ nil$ = Nil$.MODULE$;
            Nil$ apply_addingReplicas = Nil$.MODULE$;
            ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment((Seq<Object>)replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas);
            Object var7_4 = null;
            nil$ = null;
            replicaAssignment = null;
            ReplicaAssignment replicaAssignment3 = replicaAssignment2;
            Integer $minus$greater$extension_$this = tp;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_7 = null;
            replicaAssignment3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> createNewPartitionsAssignment$default$5() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").toString()).append(new StringBuilder(1).append(newPartitionAssignment).append(".").toString()).toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true);
        return combinedAssignment;
    }

    /*
     * WARNING - void declaration
     */
    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, replicas) -> AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), replicas);
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var10_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas == null) {
                        throw null;
                    }
                    if (replicas.length() != this.expectedReplicationFactor$1) {
                        void $minus$greater$extension_y;
                        Tuple2 tuple2;
                        Integer n;
                        Integer n2 = n = Integer.valueOf(replicas.length());
                        n = null;
                        Integer n3 = n2;
                        Integer $minus$greater$extension_$this = partition;
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        Object var6_7 = null;
                        n3 = null;
                        tuple2 = null;
                        object = tuple22;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                if (x1 == null) return false;
                Seq replicas = (Seq)x1._2();
                if (replicas == null) {
                    throw null;
                }
                if (replicas.length() == this.expectedReplicationFactor$1) return false;
                return true;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            void mkString_sep;
            void mkString_sep2;
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            String string = ", ";
            if (partitions == null) {
                throw null;
            }
            string = null;
            String string2 = ", ";
            if (repFactors == null) {
                throw null;
            }
            string2 = null;
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Inconsistent replication factor between partitions, ").append(new StringBuilder(42).append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString("", (String)mkString_sep2, "")).append("] have ").toString()).append(new StringBuilder(37).append("replication factors [").append(repFactors.mkString("", (String)mkString_sep, "")).append("], respectively.").toString()).toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                some = new Some((Object)Integer.parseInt(broker));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)broker).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        Object object;
        this.validateBrokerConfig(configs);
        String string = ConfigType$.MODULE$.Broker();
        if (broker == null) {
            throw null;
        }
        Object object2 = broker.isEmpty() ? None$.MODULE$ : new Some((Object)((Object)BoxesRunTime.unboxToInt((Object)broker.get())).toString());
        None$ none$ = object2;
        object2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            String string2;
            String string3 = string2 = ConfigEntityName$.MODULE$.Default();
            string2 = null;
            object = string3;
        } else {
            object = getOrElse_this.get();
        }
        Object object3 = object;
        Object var4_4 = null;
        object = null;
        this.changeEntityConfig(string, (String)object3, configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Seq $anonfun$getBrokerMetadatas$1(Seq allBrokers$1, Seq brokerIds) {
        return (Seq)allBrokers$1.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)b.id())));
    }

    public static final /* synthetic */ Seq $anonfun$getBrokerMetadatas$3(Seq allBrokers$1) {
        return allBrokers$1;
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        Option<String> option = x$1.rack();
        if (option == null) {
            throw null;
        }
        return option.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps == null) {
            throw null;
        }
        if (reps.length() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$createNewPartitionsAssignment$2(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        if (existingAssignmentPartition0$1 == null) {
            throw null;
        }
        $this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0$1.length(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()))).toSet());
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$7) {
        return x$7.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$4(Seq allBrokers$2, Seq existingAssignmentPartition0$1, int partitionsToAdd$1, Map existingAssignment$1) {
        int n = Math.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0$1, x$7))));
        if (existingAssignmentPartition0$1 == null) {
            throw null;
        }
        return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)allBrokers$2, partitionsToAdd$1, existingAssignmentPartition0$1.length(), n, existingAssignment$1.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, Seq replicas) {
        void $minus$greater$extension_y;
        Integer n;
        if (replicas.isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (replicas.length() != replicas.toSet().size()) {
            String mkString_sep = ", ";
            Object var3_3 = null;
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Duplicate brokers not allowed in replica assignment: ").append(new StringBuilder(19).append(replicas.mkString("", mkString_sep, "")).append(" for partition id ").append(partitionId).append(".").toString()).toString());
        }
        if (!replicas.toSet().subsetOf((Set)availableBrokerIds$1)) {
            String mkString_sep = ", ";
            Object var4_4 = null;
            String mkString_sep2 = ", ";
            Object var5_5 = null;
            throw new BrokerNotAvailableException(new StringBuilder(0).append(new StringBuilder(60).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").toString()).append(new StringBuilder(21).append("Specified brokers: ").append(replicas.mkString("", mkString_sep, "")).append(", ").toString()).append(new StringBuilder(20).append("available brokers: ").append(availableBrokerIds$1.mkString("", mkString_sep2, "")).append(".").toString()).toString());
        }
        Integer n2 = n = Integer.valueOf(replicas.length());
        n = null;
        Integer n3 = n2;
        Integer $minus$greater$extension_$this = partitionId;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int n = x0$1._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int n = x0$2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int n = x0$3._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$3() {
        return ConfigEntityName$.MODULE$.Default();
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$2$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        AdminZkClient.$anonfun$createNewPartitionsAssignment$2($this, existingAssignmentPartition0$1, allBrokers$2, proposedReplicaAssignment);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2$adapted(Object x$8) {
        return AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$8));
    }
}

