/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.part;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.foundation.common.part.AbstractPart;

public class FilePart
extends AbstractPart {
    private File file;

    public FilePart(String name, String file) {
        this(name, new File(file));
    }

    public FilePart(String name, File file) {
        this.name = name;
        this.file = file;
        this.setSubmittedFileName(this.file.getName());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public void write(String fileName) throws IOException {
        FileUtils.copyFile((File)this.file, (File)new File(fileName));
    }
}

