/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.pluggble.merge;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.spi.order.OrderedRegistry;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.executor.QueryResult;
import org.apache.shardingsphere.underlying.merge.MergeEntry;
import org.apache.shardingsphere.underlying.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.underlying.merge.result.MergedResult;

public final class MergeEngine {
    private final Collection<BaseRule> rules;
    private final MergeEntry merger;

    public MergeEngine(Collection<BaseRule> rules, ConfigurationProperties properties, DatabaseType databaseType, SchemaMetaData metaData) {
        this.rules = rules;
        this.merger = new MergeEntry(databaseType, metaData, properties);
    }

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        this.registerMergeDecorator();
        return this.merger.process(queryResults, sqlStatementContext);
    }

    private void registerMergeDecorator() {
        for (Class each : OrderedRegistry.getRegisteredClasses(ResultProcessEngine.class)) {
            ResultProcessEngine processEngine = this.createProcessEngine(each);
            Class ruleClass = (Class)processEngine.getType();
            this.rules.stream().filter(rule -> rule.getClass() == ruleClass || rule.getClass().getSuperclass() == ruleClass).collect(Collectors.toList()).forEach(rule -> this.merger.registerProcessEngine(rule, processEngine));
        }
    }

    private ResultProcessEngine createProcessEngine(Class<? extends ResultProcessEngine> processEngine) {
        try {
            return processEngine.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ShardingSphereException(String.format("Can not find public default constructor for result process engine `%s`", processEngine), (Exception)ex);
        }
    }
}

