/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier;

import org.apache.skywalking.apm.commons.datacarrier.BlockingDataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.EnvUtil;
import org.apache.skywalking.apm.commons.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Channels;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumeDriver;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IDriver;
import org.apache.skywalking.apm.commons.datacarrier.partition.IDataPartitioner;
import org.apache.skywalking.apm.commons.datacarrier.partition.SimpleRollingPartitioner;

public class DataCarrier<T> {
    private final int bufferSize;
    private final int channelSize;
    private Channels<T> channels;
    private IDriver driver;
    private String name;

    public DataCarrier(int channelSize, int bufferSize) {
        this("DEFAULT", channelSize, bufferSize);
    }

    public DataCarrier(String name, int channelSize, int bufferSize) {
        this(name, name, channelSize, bufferSize);
    }

    public DataCarrier(String name, String envPrefix, int channelSize, int bufferSize) {
        this.name = name;
        this.bufferSize = EnvUtil.getInt(envPrefix + "_BUFFER_SIZE", bufferSize);
        this.channelSize = EnvUtil.getInt(envPrefix + "_CHANNEL_SIZE", channelSize);
        this.channels = new Channels(channelSize, bufferSize, new SimpleRollingPartitioner(), BufferStrategy.BLOCKING);
    }

    public DataCarrier setPartitioner(IDataPartitioner<T> dataPartitioner) {
        this.channels.setPartitioner(dataPartitioner);
        return this;
    }

    public DataCarrier setBufferStrategy(BufferStrategy strategy) {
        this.channels.setStrategy(strategy);
        return this;
    }

    public BlockingDataCarrier<T> toBlockingDataCarrier() {
        this.channels.setStrategy(BufferStrategy.BLOCKING);
        return new BlockingDataCarrier<T>(this.channels);
    }

    public boolean produce(T data) {
        if (this.driver != null && !this.driver.isRunning(this.channels)) {
            return false;
        }
        return this.channels.save(data);
    }

    public DataCarrier consume(Class<? extends IConsumer<T>> consumerClass, int num, long consumeCycle) {
        if (this.driver != null) {
            this.driver.close(this.channels);
        }
        this.driver = new ConsumeDriver<T>(this.name, this.channels, consumerClass, num, consumeCycle);
        this.driver.begin(this.channels);
        return this;
    }

    public DataCarrier consume(Class<? extends IConsumer<T>> consumerClass, int num) {
        return this.consume(consumerClass, num, 20L);
    }

    public DataCarrier consume(IConsumer<T> consumer, int num, long consumeCycle) {
        if (this.driver != null) {
            this.driver.close(this.channels);
        }
        this.driver = new ConsumeDriver<T>(this.name, this.channels, consumer, num, consumeCycle);
        this.driver.begin(this.channels);
        return this;
    }

    public DataCarrier consume(IConsumer<T> consumer, int num) {
        return this.consume(consumer, num, 20L);
    }

    public DataCarrier consume(ConsumerPool consumerPool, IConsumer<T> consumer) {
        this.driver = consumerPool;
        consumerPool.add(this.name, this.channels, consumer);
        this.driver.begin(this.channels);
        return this;
    }

    public void shutdownConsumers() {
        if (this.driver != null) {
            this.driver.close(this.channels);
        }
    }
}

