/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier.buffer;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.commons.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.apm.commons.datacarrier.callback.QueueBlockingCallback;
import org.apache.skywalking.apm.commons.datacarrier.common.AtomicRangeInteger;

public class Buffer<T> {
    private final Object[] buffer;
    private BufferStrategy strategy;
    private AtomicRangeInteger index;
    private List<QueueBlockingCallback<T>> callbacks;

    Buffer(int bufferSize, BufferStrategy strategy) {
        this.buffer = new Object[bufferSize];
        this.strategy = strategy;
        this.index = new AtomicRangeInteger(0, bufferSize);
        this.callbacks = new LinkedList<QueueBlockingCallback<T>>();
    }

    void setStrategy(BufferStrategy strategy) {
        this.strategy = strategy;
    }

    void addCallback(QueueBlockingCallback<T> callback) {
        this.callbacks.add(callback);
    }

    boolean save(T data) {
        int i = this.index.getAndIncrement();
        if (this.buffer[i] != null) {
            switch (this.strategy) {
                case BLOCKING: {
                    boolean isFirstTimeBlocking = true;
                    while (this.buffer[i] != null) {
                        if (isFirstTimeBlocking) {
                            isFirstTimeBlocking = false;
                            for (QueueBlockingCallback<T> callback : this.callbacks) {
                                callback.notify(data);
                            }
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
                case IF_POSSIBLE: {
                    return false;
                }
            }
        }
        this.buffer[i] = data;
        return true;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public LinkedList<T> obtain() {
        return this.obtain(0, this.buffer.length);
    }

    public LinkedList<T> obtain(int start, int end) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = start; i < end; ++i) {
            if (this.buffer[i] == null) continue;
            result.add(this.buffer[i]);
            this.buffer[i] = null;
        }
        return result;
    }
}

