/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier.consumer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Channels;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumeDriver;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;

public enum ConsumerPoolFactory {
    INSTANCE;

    private Map<String, ConsumerPool> pools = new HashMap<String, ConsumerPool>();
    public static final ConsumerPool DEFAULT_POOL;

    public synchronized boolean createIfAbsent(String poolName, Callable<ConsumerPool> creator) throws Exception {
        if (this.pools.containsKey(poolName)) {
            return false;
        }
        this.pools.put(poolName, creator.call());
        return true;
    }

    public ConsumerPool get(String poolName) {
        return this.pools.get(poolName);
    }

    static {
        DEFAULT_POOL = new ConsumerPool(){
            private Map<Channels, ConsumeDriver> allDrivers = new HashMap<Channels, ConsumeDriver>();

            @Override
            public synchronized void add(String name, Channels channels, IConsumer consumer) {
                if (!this.allDrivers.containsKey(channels)) {
                    ConsumeDriver consumeDriver = new ConsumeDriver(name, channels, consumer, 1, 20L);
                    this.allDrivers.put(channels, consumeDriver);
                }
            }

            @Override
            public boolean isRunning(Channels channels) {
                return true;
            }

            @Override
            public void close(Channels channels) {
                ConsumeDriver driver = this.allDrivers.get(channels);
                if (driver != null) {
                    driver.close(channels);
                }
            }

            @Override
            public void begin(Channels channels) {
                ConsumeDriver driver = this.allDrivers.get(channels);
                if (driver != null) {
                    driver.begin(channels);
                }
            }
        };
    }
}

