/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.commons.datacarrier.consumer;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Buffer;
import org.apache.skywalking.apm.commons.datacarrier.buffer.Channels;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;

public class MultipleChannelsConsumer
extends Thread {
    private volatile boolean running;
    private volatile ArrayList<Group> consumeTargets = new ArrayList();
    private volatile long size;
    private final long consumeCycle;

    public MultipleChannelsConsumer(String threadName, long consumeCycle) {
        super(threadName);
        this.consumeCycle = consumeCycle;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            boolean hasData = false;
            for (Group target : this.consumeTargets) {
                hasData = hasData || this.consume(target);
            }
            if (hasData) continue;
            try {
                Thread.sleep(this.consumeCycle);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (Group target : this.consumeTargets) {
            this.consume(target);
            target.consumer.onExit();
        }
    }

    private boolean consume(Group target) {
        LinkedList consumeList = new LinkedList();
        for (int i = 0; i < target.channels.getChannelSize(); ++i) {
            Buffer buffer = target.channels.getBuffer(i);
            consumeList.addAll(buffer.obtain());
        }
        boolean hasData = consumeList.size() > 0;
        if (hasData) {
            try {
                target.consumer.consume(consumeList);
            }
            catch (Throwable t) {
                target.consumer.onError(consumeList, t);
            }
        }
        return hasData;
    }

    public void addNewTarget(Channels channels, IConsumer consumer) {
        Group group = new Group(channels, consumer);
        ArrayList<Group> newList = new ArrayList<Group>();
        for (Group target : this.consumeTargets) {
            newList.add(target);
        }
        newList.add(group);
        this.consumeTargets = newList;
        this.size += channels.size();
    }

    public long size() {
        return this.size;
    }

    void shutdown() {
        this.running = false;
    }

    private class Group {
        private Channels channels;
        private IConsumer consumer;

        public Group(Channels channels, IConsumer consumer) {
            this.channels = channels;
            this.consumer = consumer;
        }
    }
}

