/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als;

import io.kubernetes.client.ApiException;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1OwnerReference;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface Fetcher
extends Function<V1OwnerReference, Optional<V1ObjectMeta>> {
    public static final Logger logger = LoggerFactory.getLogger(Fetcher.class);

    public V1ObjectMeta go(V1OwnerReference var1) throws ApiException;

    @Override
    default public Optional<V1ObjectMeta> apply(V1OwnerReference ownerReference) {
        try {
            return Optional.ofNullable(this.go(ownerReference));
        }
        catch (ApiException e) {
            logger.error("code:{} header:{} body:{}", new Object[]{e.getCode(), e.getResponseHeaders(), e.getResponseBody()});
            return Optional.empty();
        }
        catch (Throwable th) {
            logger.error("other errors", th);
            return Optional.empty();
        }
    }
}

