/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.grpc;

import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import org.apache.skywalking.oap.server.library.server.Server;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCServer
implements Server {
    private static final Logger logger = LoggerFactory.getLogger(GRPCServer.class);
    private final String host;
    private final int port;
    private int maxConcurrentCallsPerConnection;
    private int maxMessageSize;
    private io.grpc.Server server;
    private NettyServerBuilder nettyServerBuilder;
    private SslContextBuilder sslContextBuilder;
    private File certChainFile;
    private File privateKeyFile;

    public GRPCServer(String host, int port) {
        this.host = host;
        this.port = port;
        this.maxConcurrentCallsPerConnection = 4;
        this.maxMessageSize = Integer.MAX_VALUE;
    }

    public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public GRPCServer(String host, int port, File certChainFile, File privateKeyFile) {
        this.host = host;
        this.port = port;
        this.certChainFile = certChainFile;
        this.privateKeyFile = privateKeyFile;
        this.sslContextBuilder = SslContextBuilder.forServer((File)certChainFile, (File)privateKeyFile);
    }

    @Override
    public String hostPort() {
        return this.host + ":" + this.port;
    }

    @Override
    public String serverClassify() {
        return "Google-RPC";
    }

    @Override
    public void initialize() {
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        this.nettyServerBuilder = NettyServerBuilder.forAddress((SocketAddress)address);
        this.nettyServerBuilder = this.nettyServerBuilder.maxConcurrentCallsPerConnection(this.maxConcurrentCallsPerConnection).maxMessageSize(this.maxMessageSize);
        logger.info("Server started, host {} listening on {}", (Object)this.host, (Object)this.port);
    }

    @Override
    public void start() throws ServerException {
        try {
            if (this.sslContextBuilder != null) {
                this.nettyServerBuilder = this.nettyServerBuilder.sslContext(GrpcSslContexts.configure((SslContextBuilder)this.sslContextBuilder, (SslProvider)SslProvider.OPENSSL).build());
            }
            this.server = this.nettyServerBuilder.build();
            this.server.start();
        }
        catch (IOException e) {
            throw new GRPCServerException(e.getMessage(), e);
        }
    }

    public void addHandler(BindableService handler) {
        logger.info("Bind handler {} into gRPC server {}:{}", new Object[]{handler.getClass().getSimpleName(), this.host, this.port});
        this.nettyServerBuilder.addService(handler);
    }

    public void addHandler(ServerServiceDefinition definition) {
        logger.info("Bind handler {} into gRPC server {}:{}", new Object[]{definition.getClass().getSimpleName(), this.host, this.port});
        this.nettyServerBuilder.addService(definition);
    }

    @Override
    public boolean isSSLOpen() {
        return this.sslContextBuilder == null;
    }

    @Override
    public boolean isStatusEqual(Server target) {
        if (this == target) {
            return true;
        }
        if (target == null || this.getClass() != target.getClass()) {
            return false;
        }
        GRPCServer that = (GRPCServer)target;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.certChainFile, that.certChainFile) && Objects.equals(this.privateKeyFile, that.privateKeyFile);
    }
}

