/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.zipkin.elasticsearch;

import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchProvider;
import org.apache.skywalking.oap.server.storage.plugin.zipkin.elasticsearch.ZipkinTraceQueryEsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipkinStorageModuleElasticsearchProvider
extends StorageModuleElasticsearchProvider {
    private static final Logger logger = LoggerFactory.getLogger(ZipkinStorageModuleElasticsearchProvider.class);
    private ZipkinTraceQueryEsDAO traceQueryEsDAO;

    public String name() {
        return "zipkin-elasticsearch";
    }

    public void prepare() throws ServiceNotProvidedException {
        super.prepare();
        this.traceQueryEsDAO = new ZipkinTraceQueryEsDAO(this.elasticSearchClient);
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)this.traceQueryEsDAO);
    }

    public void notifyAfterCompleted() {
        super.notifyAfterCompleted();
        this.traceQueryEsDAO.setServiceInventoryCache((ServiceInventoryCache)this.getManager().find("core").provider().getService(ServiceInventoryCache.class));
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

