/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.zipkin.elasticsearch;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.query.entity.BasicTrace;
import org.apache.skywalking.oap.server.core.query.entity.KeyValue;
import org.apache.skywalking.oap.server.core.query.entity.LogEntity;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Ref;
import org.apache.skywalking.oap.server.core.query.entity.RefType;
import org.apache.skywalking.oap.server.core.query.entity.Span;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;

public class ZipkinTraceQueryEsDAO
extends EsDAO
implements ITraceQueryDAO {
    private ServiceInventoryCache serviceInventoryCache;

    public ZipkinTraceQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, int serviceId, int serviceInstanceId, int endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (minDuration != 0L || maxDuration != 0L) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"latency");
            if (minDuration != 0L) {
                rangeQueryBuilder.gte((Object)minDuration);
            }
            if (maxDuration != 0L) {
                rangeQueryBuilder.lte((Object)maxDuration);
            }
            boolQueryBuilder.must().add(rangeQueryBuilder);
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            mustQueryList.add(QueryBuilders.matchPhraseQuery((String)"endpoint_name", (Object)endpointName));
        }
        if (serviceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        }
        if (serviceInstanceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_instance_id", (int)serviceInstanceId));
        }
        if (endpointId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"endpoint_id", (int)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        }
        switch (traceState) {
            case ERROR: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)0));
            }
        }
        TermsAggregationBuilder builder = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"trace_id").field("trace_id")).size(limit).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"latency").field("latency"))).subAggregation((AggregationBuilder)AggregationBuilders.min((String)"start_time").field("start_time"));
        switch (queryOrder) {
            case BY_START_TIME: {
                builder.order(BucketOrder.aggregation((String)"start_time", (boolean)false));
                break;
            }
            case BY_DURATION: {
                builder.order(BucketOrder.aggregation((String)"latency", (boolean)false));
            }
        }
        sourceBuilder.aggregation((AggregationBuilder)builder);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("zipkin_span", sourceBuilder);
        TraceBrief traceBrief = new TraceBrief();
        Terms terms = (Terms)response.getAggregations().get("trace_id");
        for (Terms.Bucket termsBucket : terms.getBuckets()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId(termsBucket.getKeyAsString());
            Min startTime = (Min)termsBucket.getAggregations().get("start_time");
            Max latency = (Max)termsBucket.getAggregations().get("latency");
            basicTrace.setStart(String.valueOf((long)startTime.getValue()));
            basicTrace.getEndpointNames().add("");
            basicTrace.setDuration((int)latency.getValue());
            basicTrace.setError(false);
            basicTrace.getTraceIds().add(termsBucket.getKeyAsString());
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        return Collections.emptyList();
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        sourceBuilder.sort("start_time", SortOrder.ASC);
        sourceBuilder.size(1000);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("zipkin_span", sourceBuilder);
        ArrayList<Span> spanList = new ArrayList<Span>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            int serviceId = ((Number)searchHit.getSourceAsMap().get("service_id")).intValue();
            String dataBinaryBase64 = (String)searchHit.getSourceAsMap().get("data_binary");
            zipkin2.Span span = (zipkin2.Span)SpanBytesDecoder.PROTO3.decodeOne(Base64.getDecoder().decode(dataBinaryBase64));
            Span swSpan = new Span();
            swSpan.setTraceId(span.traceId());
            swSpan.setEndpointName(span.name());
            swSpan.setStartTime(span.timestamp() / 1000L);
            swSpan.setEndTime(swSpan.getStartTime() + span.durationAsLong() / 1000L);
            span.tags().forEach((key, value) -> swSpan.getTags().add(new KeyValue(key, value)));
            span.annotations().forEach(annotation -> {
                LogEntity entity = new LogEntity();
                entity.setTime(annotation.timestamp() / 1000L);
                entity.getData().add(new KeyValue("annotation", annotation.value()));
                swSpan.getLogs().add(entity);
            });
            if (serviceId != 0) {
                swSpan.setServiceCode(this.serviceInventoryCache.get(serviceId).getName());
            }
            swSpan.setSpanId(0);
            swSpan.setParentSpanId(-1);
            swSpan.setSegmentSpanId(span.id());
            swSpan.setSegmentId(span.id());
            Span.Kind kind = span.kind();
            switch (kind) {
                case CLIENT: 
                case PRODUCER: {
                    swSpan.setType("Entry");
                    break;
                }
                case SERVER: 
                case CONSUMER: {
                    swSpan.setType("Exit");
                    break;
                }
                default: {
                    swSpan.setType("Local");
                }
            }
            if (StringUtil.isEmpty((String)span.parentId())) {
                swSpan.setRoot(true);
                swSpan.setSegmentParentSpanId("");
            } else {
                Ref ref = new Ref();
                ref.setTraceId(span.traceId());
                ref.setParentSegmentId(span.parentId());
                ref.setType(RefType.CROSS_PROCESS);
                ref.setParentSpanId(0);
                swSpan.getRefs().add(ref);
                swSpan.setSegmentParentSpanId(span.parentId());
            }
            spanList.add(swSpan);
        }
        return spanList;
    }

    public void setServiceInventoryCache(ServiceInventoryCache serviceInventoryCache) {
        this.serviceInventoryCache = serviceInventoryCache;
    }
}

