/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;

public class Bfloat16BufferIndexer
extends Bfloat16Indexer {
    protected ShortBuffer buffer;

    public Bfloat16BufferIndexer(ShortBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public Bfloat16BufferIndexer(ShortBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public float get(long i) {
        return Bfloat16BufferIndexer.toFloat(this.buffer.get((int)i));
    }

    @Override
    public Bfloat16Indexer get(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16BufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + n));
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return Bfloat16BufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j));
    }

    @Override
    public Bfloat16Indexer get(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16BufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n));
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return Bfloat16BufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k));
    }

    @Override
    public float get(long ... indices) {
        return Bfloat16BufferIndexer.toFloat(this.buffer.get((int)this.index(indices)));
    }

    @Override
    public Bfloat16Indexer get(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16BufferIndexer.toFloat(this.buffer.get((int)this.index(indices) + n));
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float h) {
        this.buffer.put((int)i, (short)Bfloat16BufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, (short)Bfloat16BufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float h) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, (short)Bfloat16BufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, (short)Bfloat16BufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, long k, float h) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, (short)Bfloat16BufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float h) {
        this.buffer.put((int)this.index(indices), (short)Bfloat16BufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, (short)Bfloat16BufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

