/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.CharBuffer;
import org.bytedeco.javacpp.indexer.CharIndexer;

public class CharBufferIndexer
extends CharIndexer {
    protected CharBuffer buffer;

    public CharBufferIndexer(CharBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public CharBufferIndexer(CharBuffer buffer, long[] sizes) {
        this(buffer, sizes, CharBufferIndexer.strides(sizes));
    }

    public CharBufferIndexer(CharBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public char get(long i) {
        return this.buffer.get((int)i);
    }

    @Override
    public CharIndexer get(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + n);
        }
        return this;
    }

    @Override
    public char get(long i, long j) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j);
    }

    @Override
    public CharIndexer get(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n);
        }
        return this;
    }

    @Override
    public char get(long i, long j, long k) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k);
    }

    @Override
    public char get(long ... indices) {
        return this.buffer.get((int)this.index(indices));
    }

    @Override
    public CharIndexer get(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get((int)this.index(indices) + n);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, char c) {
        this.buffer.put((int)i, c);
        return this;
    }

    @Override
    public CharIndexer put(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char c) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, c);
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, long k, char c) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, c);
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char c) {
        this.buffer.put((int)this.index(indices), c);
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

