/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.IntBuffer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntArrayIndexer;
import org.bytedeco.javacpp.indexer.IntBufferIndexer;
import org.bytedeco.javacpp.indexer.IntRawIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public abstract class IntIndexer
extends Indexer {
    public static final int VALUE_BYTES = 4;

    protected IntIndexer(long[] sizes, long[] strides) {
        super(sizes, strides);
    }

    public static IntIndexer create(int[] array) {
        return new IntArrayIndexer(array);
    }

    public static IntIndexer create(IntBuffer buffer) {
        return new IntBufferIndexer(buffer);
    }

    public static IntIndexer create(IntPointer pointer) {
        return IntIndexer.create(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public static IntIndexer create(int[] array, long[] sizes) {
        return new IntArrayIndexer(array, sizes);
    }

    public static IntIndexer create(IntBuffer buffer, long[] sizes) {
        return new IntBufferIndexer(buffer, sizes);
    }

    public static IntIndexer create(IntPointer pointer, long[] sizes) {
        return IntIndexer.create(pointer, sizes, IntIndexer.strides(sizes));
    }

    public static IntIndexer create(int[] array, long[] sizes, long[] strides) {
        return new IntArrayIndexer(array, sizes, strides);
    }

    public static IntIndexer create(IntBuffer buffer, long[] sizes, long[] strides) {
        return new IntBufferIndexer(buffer, sizes, strides);
    }

    public static IntIndexer create(IntPointer pointer, long[] sizes, long[] strides) {
        return IntIndexer.create(pointer, sizes, strides, true);
    }

    public static IntIndexer create(final IntPointer pointer, long[] sizes, long[] strides, boolean direct) {
        if (direct) {
            return Raw.getInstance() != null ? new IntRawIndexer(pointer, sizes, strides) : new IntBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final long position = pointer.position();
        int[] array = new int[(int)Math.min(pointer.limit() - position, Integer.MAX_VALUE)];
        pointer.get(array);
        return new IntArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract int get(long var1);

    public IntIndexer get(long i, int[] n) {
        return this.get(i, n, 0, n.length);
    }

    public abstract IntIndexer get(long var1, int[] var3, int var4, int var5);

    public abstract int get(long var1, long var3);

    public IntIndexer get(long i, long j, int[] n) {
        return this.get(i, j, n, 0, n.length);
    }

    public abstract IntIndexer get(long var1, long var3, int[] var5, int var6, int var7);

    public abstract int get(long var1, long var3, long var5);

    public abstract int get(long ... var1);

    public IntIndexer get(long[] indices, int[] n) {
        return this.get(indices, n, 0, n.length);
    }

    public abstract IntIndexer get(long[] var1, int[] var2, int var3, int var4);

    public abstract IntIndexer put(long var1, int var3);

    public IntIndexer put(long i, int ... n) {
        return this.put(i, n, 0, n.length);
    }

    public abstract IntIndexer put(long var1, int[] var3, int var4, int var5);

    public abstract IntIndexer put(long var1, long var3, int var5);

    public IntIndexer put(long i, long j, int ... n) {
        return this.put(i, j, n, 0, n.length);
    }

    public abstract IntIndexer put(long var1, long var3, int[] var5, int var6, int var7);

    public abstract IntIndexer put(long var1, long var3, long var5, int var7);

    public abstract IntIndexer put(long[] var1, int var2);

    public IntIndexer put(long[] indices, int ... n) {
        return this.put(indices, n, 0, n.length);
    }

    public abstract IntIndexer put(long[] var1, int[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... indices) {
        return this.get(indices);
    }

    @Override
    public IntIndexer putDouble(long[] indices, double n) {
        return this.put(indices, (int)n);
    }
}

