/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Point3i;
import org.bytedeco.opencv.presets.opencv_core;

@Namespace(value="cv::cuda")
@NoOffset
@Properties(inherit={opencv_core.class})
public class DeviceInfo
extends Pointer {
    public static final int ComputeModeDefault = 0;
    public static final int ComputeModeExclusive = 1;
    public static final int ComputeModeProhibited = 2;
    public static final int ComputeModeExclusiveProcess = 3;

    public DeviceInfo(Pointer p) {
        super(p);
    }

    public DeviceInfo(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    private native void allocateArray(long var1);

    public DeviceInfo position(long position) {
        return (DeviceInfo)super.position(position);
    }

    public DeviceInfo() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public DeviceInfo(int device_id) {
        super((Pointer)null);
        this.allocate(device_id);
    }

    private native void allocate(int var1);

    public native int deviceID();

    @Cast(value={"const char*"})
    public native BytePointer name();

    @Cast(value={"size_t"})
    public native long totalGlobalMem();

    @Cast(value={"size_t"})
    public native long sharedMemPerBlock();

    public native int regsPerBlock();

    public native int warpSize();

    @Cast(value={"size_t"})
    public native long memPitch();

    public native int maxThreadsPerBlock();

    @ByVal
    public native Point3i maxThreadsDim();

    @ByVal
    public native Point3i maxGridSize();

    public native int clockRate();

    @Cast(value={"size_t"})
    public native long totalConstMem();

    public native int majorVersion();

    public native int minorVersion();

    @Cast(value={"size_t"})
    public native long textureAlignment();

    @Cast(value={"size_t"})
    public native long texturePitchAlignment();

    public native int multiProcessorCount();

    @Cast(value={"bool"})
    public native boolean kernelExecTimeoutEnabled();

    @Cast(value={"bool"})
    public native boolean integrated();

    @Cast(value={"bool"})
    public native boolean canMapHostMemory();

    @Cast(value={"cv::cuda::DeviceInfo::ComputeMode"})
    public native int computeMode();

    public native int maxTexture1D();

    public native int maxTexture1DMipmap();

    public native int maxTexture1DLinear();

    @ByVal
    public native Point maxTexture2D();

    @ByVal
    public native Point maxTexture2DMipmap();

    @ByVal
    public native Point3i maxTexture2DLinear();

    @ByVal
    public native Point maxTexture2DGather();

    @ByVal
    public native Point3i maxTexture3D();

    public native int maxTextureCubemap();

    @ByVal
    public native Point maxTexture1DLayered();

    @ByVal
    public native Point3i maxTexture2DLayered();

    @ByVal
    public native Point maxTextureCubemapLayered();

    public native int maxSurface1D();

    @ByVal
    public native Point maxSurface2D();

    @ByVal
    public native Point3i maxSurface3D();

    @ByVal
    public native Point maxSurface1DLayered();

    @ByVal
    public native Point3i maxSurface2DLayered();

    public native int maxSurfaceCubemap();

    @ByVal
    public native Point maxSurfaceCubemapLayered();

    @Cast(value={"size_t"})
    public native long surfaceAlignment();

    @Cast(value={"bool"})
    public native boolean concurrentKernels();

    @Cast(value={"bool"})
    public native boolean ECCEnabled();

    public native int pciBusID();

    public native int pciDeviceID();

    public native int pciDomainID();

    @Cast(value={"bool"})
    public native boolean tccDriver();

    public native int asyncEngineCount();

    @Cast(value={"bool"})
    public native boolean unifiedAddressing();

    public native int memoryClockRate();

    public native int memoryBusWidth();

    public native int l2CacheSize();

    public native int maxThreadsPerMultiProcessor();

    public native void queryMemory(@Cast(value={"size_t*"}) @ByRef SizeTPointer var1, @Cast(value={"size_t*"}) @ByRef SizeTPointer var2);

    @Cast(value={"size_t"})
    public native long freeMemory();

    @Cast(value={"size_t"})
    public native long totalMemory();

    @Cast(value={"bool"})
    public native boolean supports(@Cast(value={"cv::cuda::FeatureSet"}) int var1);

    @Cast(value={"bool"})
    public native boolean isCompatible();

    static {
        Loader.load();
    }
}

