/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.nio.file.Path;
import java.util.Locale;
import javafx.util.Builder;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;

public class KeyBoardBuilder
implements Builder<KeyboardPane> {
    private final KeyboardPane kb = new KeyboardPane();

    protected KeyBoardBuilder() {
    }

    public static KeyBoardBuilder create() {
        return new KeyBoardBuilder();
    }

    public KeyBoardBuilder layerPath(Path path) {
        this.kb.setLayerPath(path);
        return this;
    }

    public KeyBoardBuilder layer(DefaultLayer layer) {
        this.kb.setLayer(layer);
        return this;
    }

    public KeyBoardBuilder style(String css) {
        this.kb.setStyle(css);
        return this;
    }

    public KeyBoardBuilder initLocale(Locale locale) {
        this.kb.setLocale(locale);
        return this;
    }

    public KeyBoardBuilder initScale(double scale) {
        this.kb.setScale(scale);
        return this;
    }

    public KeyBoardBuilder addIRobot(IRobot robot) {
        this.kb.addRobotHandler(robot);
        return this;
    }

    public KeyboardPane build() {
        try {
            this.kb.load();
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
        return this.kb;
    }
}

