/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.control.KeyboardType;
import org.comtel2000.keyboard.control.VkProperties;

public class KeyBoardPopup
extends Popup
implements VkProperties {
    private final KeyboardPane keyboard;
    private Scene owner;
    private final DoubleProperty offsetProperty = new SimpleDoubleProperty((Object)this, "offset", 5.0);
    private FadeTransition animation;
    public static final EventHandler<? super Event> DEFAULT_CLOSE_HANDLER = event -> {
        if (event.getSource() instanceof Node) {
            ((Node)event.getSource()).fireEvent((Event)new WindowEvent(null, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    };

    public KeyBoardPopup(KeyboardPane panel) {
        this.keyboard = Objects.requireNonNull(panel);
        this.getContent().add((Object)this.keyboard);
    }

    public final KeyboardPane getKeyBoard() {
        return this.keyboard;
    }

    public boolean isVisible() {
        return this.isShowing();
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible ? Visiblity.SHOW : Visiblity.HIDE);
    }

    public Scene getRegisteredScene() {
        return this.owner;
    }

    public void registerScene(Scene scene) {
        this.owner = Objects.requireNonNull(scene);
    }

    public void addFocusListener(Scene scene) {
        this.addFocusListener(scene, false);
    }

    public void addFocusListener(Scene scene, boolean doNotOpen) {
        this.registerScene(scene);
        scene.focusOwnerProperty().addListener((value, n1, n2) -> {
            if (n2 != null && n2 instanceof TextInputControl) {
                this.setVisible(doNotOpen ? Visiblity.POS : Visiblity.SHOW, (TextInputControl)n2);
            } else if (n2 != null && n2 instanceof Parent) {
                TextInputControl control = KeyBoardPopup.findTextInputControl((Parent)n2);
                this.setVisible(control != null ? (doNotOpen ? Visiblity.POS : Visiblity.SHOW) : Visiblity.HIDE, control);
            } else {
                this.setVisible(Visiblity.HIDE);
            }
        });
    }

    private static TextInputControl findTextInputControl(Parent parent) {
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (!(child instanceof TextInputControl)) continue;
            return (TextInputControl)child;
        }
        return null;
    }

    public void addDoubleClickEventFilter(Stage stage) {
        Objects.requireNonNull(stage).addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            Node node;
            if (event.getClickCount() == 2 && stage.getScene() != null && (node = stage.getScene().getFocusOwner()) != null && node instanceof TextInputControl) {
                this.setVisible(Visiblity.SHOW, (TextInputControl)node);
            }
        });
    }

    public void setOnKeyboardCloseButton(EventHandler<? super Event> value) {
        this.getKeyBoard().setOnKeyboardCloseButton(value);
    }

    void setVisible(Visiblity visible) {
        this.setVisible(visible, null);
    }

    void setVisible(Visiblity visible, TextInputControl textNode) {
        if ((visible == Visiblity.POS || visible == Visiblity.SHOW) && textNode != null) {
            Map<String, String> vkProps = this.getVkProperties((Node)textNode);
            if (vkProps.isEmpty()) {
                this.getKeyBoard().setKeyboardType(KeyboardType.TEXT);
            } else {
                this.getKeyBoard().setKeyboardType(vkProps.getOrDefault("vkType", "text"));
                if (vkProps.containsKey("vkLocale")) {
                    this.getKeyBoard().switchLocale(new Locale(vkProps.get("vkLocale")));
                }
            }
            Bounds textNodeBounds = textNode.localToScreen(textNode.getBoundsInLocal());
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            if (textNodeBounds.getMinX() + this.getWidth() > screenBounds.getMaxX()) {
                this.setX(screenBounds.getMaxX() - this.getWidth());
            } else {
                this.setX(textNodeBounds.getMinX());
            }
            if (textNodeBounds.getMaxY() + this.getHeight() > screenBounds.getMaxY()) {
                this.setY(textNodeBounds.getMinY() - this.getHeight() - this.offsetProperty.get());
            } else {
                this.setY(textNodeBounds.getMaxY() + this.offsetProperty.get());
            }
        }
        if (visible == Visiblity.POS || visible == Visiblity.HIDE && !this.isShowing()) {
            return;
        }
        if (this.animation != null) {
            this.animation.stop();
        } else {
            this.animation = new FadeTransition(Duration.millis((double)100.0), (Node)this.getKeyBoard());
            this.animation.setOnFinished(e -> {
                if (this.animation.toValueProperty().get() == 0.0) {
                    this.hide();
                }
            });
        }
        this.animation.setFromValue(visible == Visiblity.SHOW ? 0.0 : 1.0);
        this.animation.setToValue(visible == Visiblity.SHOW ? 1.0 : 0.0);
        if (visible == Visiblity.SHOW && !this.isShowing()) {
            super.show(this.owner != null ? this.owner.getWindow() : this.getOwnerWindow());
        }
        this.animation.playFromStart();
    }

    private Map<String, String> getVkProperties(Node node) {
        if (node.hasProperties()) {
            HashMap<String, String> vkProps = new HashMap<String, String>(3);
            node.getProperties().forEach((key, value) -> {
                if (key.toString().startsWith("vk")) {
                    vkProps.put(String.valueOf(key), String.valueOf(value));
                }
            });
            return vkProps;
        }
        if (node.getParent() != null && node.getParent().hasProperties()) {
            HashMap<String, String> vkProps = new HashMap<String, String>(3);
            node.getParent().getProperties().forEach((key, value) -> {
                if (key.toString().startsWith("vk")) {
                    vkProps.put(String.valueOf(key), String.valueOf(value));
                }
            });
            return vkProps;
        }
        return Collections.emptyMap();
    }

    public final DoubleProperty offsetProperty() {
        return this.offsetProperty;
    }

    public final void setOffset(double offsetProperty) {
        this.offsetProperty().set(offsetProperty);
    }

    static enum Visiblity {
        SHOW,
        HIDE,
        POS;

    }
}

