/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.comtel2000.keyboard.control.LongPressable;
import org.comtel2000.keyboard.event.KeyButtonEvent;

public abstract class KeyButton
extends Button
implements LongPressable {
    private static final long DEFAULT_DELAY = 400L;
    private String keyText;
    private boolean movable;
    private boolean repeatable;
    private int keyCode;
    protected Timeline buttonDelay;
    private EventHandler<? super KeyButtonEvent> _onLongPressed = null;
    private ObjectProperty<EventHandler<? super KeyButtonEvent>> onLongPressed;
    private EventHandler<? super KeyButtonEvent> _onShortPressed = null;
    private ObjectProperty<EventHandler<? super KeyButtonEvent>> onShortPressed;

    public KeyButton() {
        this(null, null, 400L);
    }

    public KeyButton(String label) {
        this(label, null, 400L);
    }

    public KeyButton(Node graphic) {
        this(null, graphic, 400L);
    }

    public KeyButton(String label, Node graphic) {
        this(label, graphic, 400L);
    }

    public KeyButton(String label, long delay) {
        this(label, null, delay);
    }

    public KeyButton(String label, Node graphic, long delay) {
        super(label, graphic);
        this.getStyleClass().add((Object)"key-button");
        this.initEventListener(delay > 0L ? delay : 400L);
    }

    protected abstract void initEventListener(long var1);

    protected void fireLongPressed() {
        this.fireEvent(new KeyButtonEvent(this, KeyButtonEvent.LONG_PRESSED));
    }

    protected void fireShortPressed() {
        this.fireEvent(new KeyButtonEvent(this, KeyButtonEvent.SHORT_PRESSED));
    }

    @Override
    public final EventHandler<? super KeyButtonEvent> getOnLongPressed() {
        return this.onLongPressed == null ? this._onLongPressed : (EventHandler)this.onLongPressed.get();
    }

    @Override
    public final void setOnLongPressed(EventHandler<? super KeyButtonEvent> h) {
        this.onLongPressedProperty().set(h);
    }

    @Override
    public final ObjectProperty<EventHandler<? super KeyButtonEvent>> onLongPressedProperty() {
        if (this.onLongPressed == null) {
            this.onLongPressed = new SimpleObjectProperty<EventHandler<? super KeyButtonEvent>>((Object)this, "onLongPressed", this._onLongPressed){

                protected void invalidated() {
                    KeyButton.this.setEventHandler(KeyButtonEvent.LONG_PRESSED, (EventHandler)this.get());
                }
            };
        }
        return this.onLongPressed;
    }

    @Override
    public final EventHandler<? super KeyButtonEvent> getOnShortPressed() {
        return this.onShortPressed == null ? this._onShortPressed : (EventHandler)this.onShortPressed.get();
    }

    @Override
    public final void setOnShortPressed(EventHandler<? super KeyButtonEvent> h) {
        this.onShortPressedProperty().set(h);
    }

    @Override
    public final ObjectProperty<EventHandler<? super KeyButtonEvent>> onShortPressedProperty() {
        if (this.onShortPressed == null) {
            this.onShortPressed = new SimpleObjectProperty<EventHandler<? super KeyButtonEvent>>((Object)this, "onShortPressed", this._onShortPressed){

                protected void invalidated() {
                    KeyButton.this.setEventHandler(KeyButtonEvent.SHORT_PRESSED, (EventHandler)this.get());
                }
            };
        }
        return this.onShortPressed;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    public String getKeyText() {
        return this.keyText;
    }

    public void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    public void addExtKeyCode(int keyCode, String label) {
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }
}

