/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.control;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.input.MouseButton;
import javafx.util.Duration;
import org.comtel2000.keyboard.control.KeyButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepeatableKeyButton
extends KeyButton {
    private static final Logger logger = LoggerFactory.getLogger(RepeatableKeyButton.class);
    private final long REPEAT_DELAY = 40L;

    RepeatableKeyButton() {
        this.getStyleClass().add((Object)"repeatable-button");
    }

    @Override
    protected void initEventListener(long delay) {
        this.buttonDelay = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), event -> {
            this.fireShortPressed();
            this.buttonDelay.playFrom(this.buttonDelay.getCycleDuration().subtract(Duration.millis((double)40.0)));
        }, new KeyValue[0])});
        this.setOnDragDetected(e -> {
            logger.trace("{} drag detected", (Object)this.getKeyCode());
            this.buttonDelay.stop();
            e.consume();
        });
        this.setOnMousePressed(e -> {
            logger.trace("{} pressed", (Object)this.getKeyCode());
            if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
                if (!this.isMovable()) {
                    this.fireShortPressed();
                }
                this.buttonDelay.playFromStart();
            }
            e.consume();
        });
        this.setOnMouseReleased(e -> {
            logger.trace("{} released", (Object)this.getKeyCode());
            if (this.isMovable() && this.buttonDelay.getStatus() == Animation.Status.RUNNING) {
                this.fireShortPressed();
            }
            this.buttonDelay.stop();
            this.setFocused(false);
            e.consume();
        });
    }
}

