/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.robot;

import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRobotHandler
implements IRobot {
    private static final Logger logger = LoggerFactory.getLogger(FXRobotHandler.class);
    private final KeyCode controlKeyCode;

    public FXRobotHandler() {
        String osName = System.getProperty("os.name");
        this.controlKeyCode = osName.toLowerCase().startsWith("mac") ? KeyCode.META : KeyCode.CONTROL;
    }

    @Override
    public void sendToComponent(Object kb, char ch, boolean ctrl) {
        logger.trace("fire: {}", (Object)Character.valueOf(ch));
        Window keyboardWindow = ((KeyboardPane)kb).getScene().getWindow();
        if (keyboardWindow != null) {
            Scene scene = keyboardWindow instanceof Popup ? ((Popup)keyboardWindow).getOwnerWindow().getScene() : keyboardWindow.getScene();
            Platform.runLater(() -> this.send(scene, ch, ctrl));
        }
    }

    private void send(Scene scene, char ch, boolean ctrl) {
        Node focusNode = (Node)scene.focusOwnerProperty().get();
        if (focusNode == null) {
            logger.error("no focus owner");
            return;
        }
        if (ctrl) {
            switch (ch) {
                case '\n': {
                    this.firePressedReleased(focusNode, ch, KeyCode.ENTER);
                    return;
                }
                case '\b': {
                    this.firePressedReleased(focusNode, ch, KeyCode.BACK_SPACE);
                    return;
                }
                case '\u007f': {
                    this.firePressedReleased(focusNode, ch, KeyCode.DELETE);
                    return;
                }
                case '\u001b': {
                    this.firePressedReleased(focusNode, ch, KeyCode.ESCAPE);
                    return;
                }
                case ' ': {
                    this.firePressedReleased(focusNode, ch, KeyCode.SPACE);
                    return;
                }
                case '\t': {
                    this.firePressedReleased(focusNode, ch, KeyCode.TAB);
                    return;
                }
                case '&': {
                    this.firePressedReleased(focusNode, ch, KeyCode.UP);
                    return;
                }
                case '(': {
                    this.firePressedReleased(focusNode, ch, KeyCode.DOWN);
                    return;
                }
                case '%': {
                    this.firePressedReleased(focusNode, ch, KeyCode.LEFT);
                    return;
                }
                case '\'': {
                    this.firePressedReleased(focusNode, ch, KeyCode.RIGHT);
                    return;
                }
                case '$': {
                    this.firePressedReleased(focusNode, ch, KeyCode.HOME);
                    return;
                }
                case '#': {
                    this.firePressedReleased(focusNode, ch, KeyCode.END);
                    return;
                }
                case '!': {
                    this.firePressedReleased(focusNode, ch, KeyCode.PAGE_UP);
                    return;
                }
                case '\"': {
                    this.firePressedReleased(focusNode, ch, KeyCode.PAGE_DOWN);
                    return;
                }
                case '\u009c': {
                    this.firePressedReleased(focusNode, ch, KeyCode.HELP);
                    return;
                }
                case '\u009a': {
                    this.firePressedReleased(focusNode, ch, KeyCode.PRINTSCREEN);
                    return;
                }
                case 'p': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F1);
                    return;
                }
                case 'q': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F2);
                    return;
                }
                case 'r': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F3);
                    return;
                }
                case 's': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F4);
                    return;
                }
                case 't': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F5);
                    return;
                }
                case 'u': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F6);
                    return;
                }
                case 'v': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F7);
                    return;
                }
                case 'w': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F8);
                    return;
                }
                case 'x': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F9);
                    return;
                }
                case 'y': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F10);
                    return;
                }
                case 'z': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F11);
                    return;
                }
                case '{': {
                    this.firePressedReleased(focusNode, ch, KeyCode.F12);
                    return;
                }
            }
            KeyCode fxKeyCode = this.getKeyCode(ch);
            if (fxKeyCode != null) {
                focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, Character.toString(ch), fxKeyCode, ctrl));
                focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, Character.toString(ch), fxKeyCode, ctrl));
                return;
            }
        }
        focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, Character.toString(ch), KeyCode.UNDEFINED, ctrl));
        if (Character.toString(ch) != KeyEvent.CHAR_UNDEFINED) {
            focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_TYPED, Character.toString(ch), KeyCode.UNDEFINED, ctrl));
        }
        focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, Character.toString(ch), KeyCode.UNDEFINED, ctrl));
    }

    private KeyCode getKeyCode(char c) {
        return KeyCode.getKeyCode((String)Character.toString(Character.toUpperCase(c)));
    }

    private void firePressedReleased(Node focusNode, char ch, KeyCode code) {
        focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, Character.toString(ch), code, false));
        focusNode.fireEvent((Event)this.createKeyEvent((EventTarget)focusNode, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, Character.toString(ch), code, false));
    }

    private KeyEvent createKeyEvent(EventTarget target, EventType<KeyEvent> eventType, String character, KeyCode code, boolean ctrl) {
        return new KeyEvent(eventType, character, code.toString(), code, false, ctrl && this.controlKeyCode == KeyCode.CONTROL, false, ctrl && this.controlKeyCode == KeyCode.META);
    }
}

