/*
 * Decompiled with CFR 0.152.
 */
package org.comtel2000.keyboard.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.comtel2000.keyboard.xml.layout.Keyboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyboardLayoutHandler {
    private static final Logger logger = LoggerFactory.getLogger(KeyboardLayoutHandler.class);
    private ConcurrentHashMap<String, Keyboard> layoutStringCache;
    private ConcurrentHashMap<URL, Keyboard> layoutURLCache;
    private JAXBContext context;
    private Unmarshaller unmarshaller;

    public KeyboardLayoutHandler() {
        this(false);
    }

    public KeyboardLayoutHandler(boolean cached) {
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{Keyboard.class});
            this.unmarshaller = this.context.createUnmarshaller();
            if (cached) {
                this.layoutStringCache = new ConcurrentHashMap(8);
                this.layoutURLCache = new ConcurrentHashMap(8);
            }
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Keyboard getLayout(String file) throws IOException {
        if (this.layoutStringCache != null) {
            return this.layoutStringCache.computeIfAbsent(file, f -> {
                URL url = KeyboardLayoutHandler.class.getResource((String)f);
                try {
                    if (url != null) {
                        return this.getLayout(url);
                    }
                    return this.getLayout(KeyboardLayoutHandler.class.getResourceAsStream((String)f));
                }
                catch (Exception e) {
                    logger.error("file: " + String.valueOf(f) + " can not be read", (Throwable)e);
                    return null;
                }
            });
        }
        URL url = KeyboardLayoutHandler.class.getResource(file);
        if (url != null) {
            return this.getLayout(url);
        }
        InputStream is = KeyboardLayoutHandler.class.getResourceAsStream(file);
        if (is != null) {
            return this.getLayout(is);
        }
        throw new IOException("layout not found on: " + file);
    }

    public Keyboard getLayout(URL url) throws IOException {
        if (this.layoutURLCache != null) {
            return this.layoutURLCache.computeIfAbsent(url, u -> {
                Object obj = null;
                try {
                    obj = this.unmarshaller.unmarshal(u);
                }
                catch (JAXBException e) {
                    logger.error("file: " + String.valueOf(u) + " can not be read", (Throwable)e);
                }
                if (obj != null && obj instanceof Keyboard) {
                    return (Keyboard)obj;
                }
                return null;
            });
        }
        Object obj = null;
        try {
            obj = this.unmarshaller.unmarshal(url);
        }
        catch (JAXBException e) {
            throw new IOException("file: " + url + " can not be read", e);
        }
        if (obj != null && obj instanceof Keyboard) {
            return (Keyboard)obj;
        }
        return null;
    }

    private Keyboard getLayout(InputStream is) throws IOException {
        Object obj = null;
        try {
            obj = this.unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new IOException("stream can not be read", e);
        }
        if (obj != null && obj instanceof Keyboard) {
            return (Keyboard)obj;
        }
        return null;
    }
}

