/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebInfConfiguration.class);
    public static final String TEMPDIR_CONFIGURED = "org.eclipse.jetty.tmpdirConfigured";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final String RESOURCE_URLS = "org.eclipse.jetty.resources";
    protected Resource _preUnpackBaseResource;

    @Override
    public void preConfigure(final WebAppContext context) throws Exception {
        File work = this.findWorkDirectory(context);
        if (work != null) {
            this.makeTempDirectory(work, context, false);
        }
        this.resolveTempDirectory(context);
        this.unpack(context);
        String tmp = (String)context.getAttribute(WEBINF_JAR_PATTERN);
        Pattern webInfPattern = tmp == null ? null : Pattern.compile(tmp);
        tmp = (String)context.getAttribute(CONTAINER_JAR_PATTERN);
        Pattern containerPattern = tmp == null ? null : Pattern.compile(tmp);
        PatternMatcher containerJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                context.getMetaData().addContainerJar(Resource.newResource((URI)uri));
            }
        };
        for (ClassLoader loader = context.getClassLoader(); loader != null && loader instanceof URLClassLoader; loader = loader.getParent()) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls == null) continue;
            URI[] containerUris = new URI[urls.length];
            int i = 0;
            for (URL u : urls) {
                try {
                    containerUris[i] = u.toURI();
                }
                catch (URISyntaxException e) {
                    containerUris[i] = new URI(u.toString().replaceAll(" ", "%20"));
                }
                ++i;
            }
            containerJarNameMatcher.match(containerPattern, containerUris, false);
        }
        PatternMatcher webInfJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                context.getMetaData().addWebInfJar(Resource.newResource((URI)uri));
            }
        };
        List<Resource> jars = this.findJars(context);
        URI[] uris = null;
        if (jars != null) {
            uris = new URI[jars.size()];
            int i = 0;
            for (Resource r : jars) {
                uris[i++] = r.getURI();
            }
        }
        webInfJarNameMatcher.match(webInfPattern, uris, true);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        List resources;
        if (context.isStarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot configure webapp " + context + " after it is started", new Object[0]);
            }
            return;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = web_inf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if ((lib = web_inf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
        if ((resources = (List)context.getAttribute(RESOURCE_URLS)) != null) {
            Resource[] collection = new Resource[resources.size() + 1];
            int i = 0;
            collection[i++] = context.getBaseResource();
            for (Resource resource : resources) {
                collection[i++] = resource;
            }
            context.setBaseResource((Resource)new ResourceCollection(collection));
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Boolean tmpdirConfigured = (Boolean)context.getAttribute(TEMPDIR_CONFIGURED);
        if (!(context.getTempDirectory() == null || tmpdirConfigured != null && tmpdirConfigured.booleanValue() || this.isTempWorkDirectory(context.getTempDirectory()))) {
            IO.delete((File)context.getTempDirectory());
            context.setTempDirectory(null);
            context.setAttribute(TEMPDIR_CONFIGURED, null);
            context.setAttribute("javax.servlet.context.tempdir", null);
        }
        context.setBaseResource(this._preUnpackBaseResource);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        File tmpDir = File.createTempFile(WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context), "", template.getTempDirectory().getParentFile());
        if (tmpDir.exists()) {
            IO.delete((File)tmpDir);
        }
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        context.setTempDirectory(tmpDir);
    }

    public void resolveTempDirectory(WebAppContext context) {
        File tmpDir = context.getTempDirectory();
        if (tmpDir != null && tmpDir.isDirectory() && tmpDir.canWrite()) {
            context.setAttribute(TEMPDIR_CONFIGURED, Boolean.TRUE);
            return;
        }
        File servletTmpDir = this.asFile(context.getAttribute("javax.servlet.context.tempdir"));
        if (servletTmpDir != null && servletTmpDir.isDirectory() && servletTmpDir.canWrite()) {
            tmpDir = servletTmpDir;
            context.setAttribute("javax.servlet.context.tempdir", tmpDir);
            context.setTempDirectory(tmpDir);
            return;
        }
        try {
            File work = new File(System.getProperty("jetty.home"), "work");
            if (work.exists() && work.canWrite() && work.isDirectory()) {
                this.makeTempDirectory(work, context, false);
            } else {
                File baseTemp = this.asFile(context.getAttribute("org.eclipse.jetty.webapp.basetempdir"));
                if (baseTemp != null && baseTemp.isDirectory() && baseTemp.canWrite()) {
                    this.makeTempDirectory(baseTemp, context, false);
                } else {
                    this.makeTempDirectory(new File(System.getProperty("java.io.tmpdir")), context, true);
                }
            }
        }
        catch (Exception e) {
            tmpDir = null;
            LOG.ignore((Throwable)e);
        }
        if (context.getTempDirectory() == null) {
            try {
                tmpDir = File.createTempFile("JettyContext", "");
                if (tmpDir.exists()) {
                    IO.delete((File)tmpDir);
                }
                tmpDir.mkdir();
                tmpDir.deleteOnExit();
                context.setTempDirectory(tmpDir);
            }
            catch (IOException e) {
                tmpDir = null;
                throw new IllegalStateException("Cannot create tmp dir in " + System.getProperty("java.io.tmpdir") + " for context " + context, e);
            }
        }
    }

    private File asFile(Object fileattr) {
        if (fileattr == null) {
            return null;
        }
        if (fileattr instanceof File) {
            return (File)fileattr;
        }
        if (fileattr instanceof String) {
            return new File((String)fileattr);
        }
        return null;
    }

    public void makeTempDirectory(File parent, WebAppContext context, boolean deleteExisting) throws IOException {
        if (parent != null && parent.exists() && parent.canWrite() && parent.isDirectory()) {
            String temp = WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context);
            File tmpDir = new File(parent, temp);
            if (deleteExisting && tmpDir.exists()) {
                if (!IO.delete((File)tmpDir) && LOG.isDebugEnabled()) {
                    LOG.debug("Failed to delete temp dir " + tmpDir, new Object[0]);
                }
                if (tmpDir.exists()) {
                    String old = tmpDir.toString();
                    tmpDir = File.createTempFile(temp + "_", "");
                    if (tmpDir.exists()) {
                        IO.delete((File)tmpDir);
                    }
                    LOG.warn("Can't reuse " + old + ", using " + tmpDir, new Object[0]);
                }
            }
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
            }
            if (!this.isTempWorkDirectory(tmpDir)) {
                tmpDir.deleteOnExit();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set temp dir " + tmpDir, new Object[0]);
            }
            context.setTempDirectory(tmpDir);
        }
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource web_app = context.getBaseResource();
        this._preUnpackBaseResource = context.getBaseResource();
        if (web_app == null) {
            Resource jarWebApp;
            String war = context.getWar();
            web_app = war != null && war.length() > 0 ? context.newResource(war) : context.getBaseResource();
            if (web_app.getAlias() != null) {
                LOG.debug(web_app + " anti-aliased to " + web_app.getAlias(), new Object[0]);
                web_app = context.newResource(web_app.getAlias());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory() + " file=" + web_app.getFile(), new Object[0]);
            }
            if (web_app.exists() && !web_app.isDirectory() && !web_app.toString().startsWith("jar:") && (jarWebApp = JarResource.newJarResource((Resource)web_app)).exists() && jarWebApp.isDirectory()) {
                web_app = jarWebApp;
            }
            if (web_app.exists() && (context.isCopyWebDir() && web_app.getFile() != null && web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() != null && !web_app.getFile().isDirectory() || context.isExtractWAR() && web_app.getFile() == null || !web_app.isDirectory())) {
                File sibling;
                File warfile;
                File extractedWebAppDir = null;
                if (war != null && (warfile = Resource.newResource((String)war).getFile()) != null && warfile.getName().toLowerCase(Locale.ENGLISH).endsWith(".war") && (sibling = new File(warfile.getParent(), warfile.getName().substring(0, warfile.getName().length() - 4))).exists() && sibling.isDirectory() && sibling.canWrite()) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = new File(context.getTempDirectory(), "webapp");
                }
                if (web_app.getFile() != null && web_app.getFile().isDirectory()) {
                    LOG.debug("Copy " + web_app + " to " + extractedWebAppDir, new Object[0]);
                    web_app.copyTo(extractedWebAppDir);
                } else {
                    Resource jar_web_app;
                    File extractionLock = new File(context.getTempDirectory(), ".extract_lock");
                    if (!extractedWebAppDir.exists()) {
                        extractionLock.createNewFile();
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + web_app + " to " + extractedWebAppDir, new Object[0]);
                        jar_web_app = JarResource.newJarResource((Resource)web_app);
                        jar_web_app.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    } else if (web_app.lastModified() > extractedWebAppDir.lastModified() || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        IO.delete((File)extractedWebAppDir);
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + web_app + " to " + extractedWebAppDir, new Object[0]);
                        jar_web_app = JarResource.newJarResource((Resource)web_app);
                        jar_web_app.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    }
                }
                web_app = Resource.newResource((String)extractedWebAppDir.getCanonicalPath());
            }
            if (!web_app.exists() || !web_app.isDirectory()) {
                LOG.warn("Web application not found " + war, new Object[0]);
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(web_app);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp=" + web_app, new Object[0]);
            }
        }
        if (context.isCopyWebInf() && !context.isCopyWebDir()) {
            Resource web_inf_classes;
            Resource web_inf = web_app.addPath("WEB-INF/");
            File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
            if (extractedWebInfDir.exists()) {
                IO.delete((File)extractedWebInfDir);
            }
            extractedWebInfDir.mkdir();
            Resource web_inf_lib = web_inf.addPath("lib/");
            File webInfDir = new File(extractedWebInfDir, "WEB-INF");
            webInfDir.mkdir();
            if (web_inf_lib.exists()) {
                File webInfLibDir = new File(webInfDir, "lib");
                if (webInfLibDir.exists()) {
                    IO.delete((File)webInfLibDir);
                }
                webInfLibDir.mkdir();
                LOG.debug("Copying WEB-INF/lib " + web_inf_lib + " to " + webInfLibDir, new Object[0]);
                web_inf_lib.copyTo(webInfLibDir);
            }
            if ((web_inf_classes = web_inf.addPath("classes/")).exists()) {
                File webInfClassesDir = new File(webInfDir, "classes");
                if (webInfClassesDir.exists()) {
                    IO.delete((File)webInfClassesDir);
                }
                webInfClassesDir.mkdir();
                LOG.debug("Copying WEB-INF/classes from " + web_inf_classes + " to " + webInfClassesDir.getAbsolutePath(), new Object[0]);
                web_inf_classes.copyTo(webInfClassesDir);
            }
            web_inf = Resource.newResource((String)extractedWebInfDir.getCanonicalPath());
            ResourceCollection rc = new ResourceCollection(new Resource[]{web_inf, web_app});
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.resourcebase = " + rc, new Object[0]);
            }
            context.setBaseResource((Resource)rc);
        }
    }

    public File findWorkDirectory(WebAppContext context) throws IOException {
        Resource web_inf;
        if (context.getBaseResource() != null && (web_inf = context.getWebInf()) != null && web_inf.exists()) {
            return new File(web_inf.getFile(), "work");
        }
        return null;
    }

    public boolean isTempWorkDirectory(File tmpDir) {
        if (tmpDir == null) {
            return false;
        }
        if (tmpDir.getName().equalsIgnoreCase("work")) {
            return true;
        }
        File t = tmpDir.getParentFile();
        if (t == null) {
            return false;
        }
        return t.getName().equalsIgnoreCase("work");
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        int i;
        Connector[] connectors;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("jetty-");
        Server server = context.getServer();
        if (server != null && (connectors = context.getServer().getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            if (connectors != null && connectors[0] instanceof NetworkConnector) {
                NetworkConnector connector = (NetworkConnector)connectors[0];
                host = connector.getHost();
                port = connector.getLocalPort();
                if (port < 0) {
                    port = connector.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            String tmp;
            Resource resource = context.getBaseResource();
            if (resource == null) {
                if (context.getWar() == null || context.getWar().length() == 0) {
                    resource = context.newResource(context.getResourceBase());
                }
                resource = context.newResource(context.getWar());
            }
            if ((tmp = URIUtil.decodePath((String)resource.getURL().getPath())).endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            if (tmp.endsWith("!")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            i = tmp.lastIndexOf("/");
            canonicalName.append(tmp.substring(i + 1, tmp.length()));
            canonicalName.append("-");
        }
        catch (Exception e) {
            LOG.warn("Can't generate resourceBase as part of webapp tmp dir name", (Throwable)e);
        }
        String contextPath = context.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("-");
        String[] vhosts = context.getVirtualHosts();
        if (vhosts == null || vhosts.length <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts[0]);
        }
        for (i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || "-.".indexOf(c) >= 0) continue;
            canonicalName.setCharAt(i, '.');
        }
        canonicalName.append("-");
        return canonicalName.toString();
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        Resource web_inf = context.getWebInf();
        if (web_inf == null || !web_inf.exists()) {
            return null;
        }
        Resource web_inf_lib = web_inf.addPath("/lib");
        if (web_inf_lib.exists() && web_inf_lib.isDirectory()) {
            String[] files = web_inf_lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String extension;
                    Resource file = web_inf_lib.addPath(files[f]);
                    String fnlc = file.getName().toLowerCase(Locale.ENGLISH);
                    int dot = fnlc.lastIndexOf(46);
                    String string = extension = dot < 0 ? null : fnlc.substring(dot);
                    if (extension == null || !extension.equals(".jar") && !extension.equals(".zip")) continue;
                    jarResources.add(file);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", (Throwable)ex);
                }
            }
        }
        return jarResources;
    }
}

