/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.switcher;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.web.context.ContextKey;
import org.hswebframework.web.context.ContextUtils;
import org.hswebframework.web.datasource.switcher.ReactiveSwitcher;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveSwitcher
implements ReactiveSwitcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactiveSwitcher.class);
    private String name;
    private String defaultId;
    private String type;

    public DefaultReactiveSwitcher(String name, String type) {
        this.name = "ReactiveSwitcher.".concat(name);
        this.defaultId = name.concat(".").concat("_default");
        this.type = type;
    }

    private <R> Mono<R> doInContext(Function<Deque<String>, Mono<R>> function) {
        return ContextUtils.reactiveContext().map(ctx -> (Deque)ctx.getOrDefault(ContextKey.of((String)this.name), LinkedList::new)).flatMap(function);
    }

    private <R extends Publisher<?>> R doInContext(R publisher, Consumer<Deque<String>> consumer) {
        if (publisher instanceof Mono) {
            return (R)((Mono)publisher).subscriberContext(ContextUtils.acceptContext(ctx -> consumer.accept((Deque<String>)ctx.getOrDefault(ContextKey.of((String)this.name), LinkedList::new))));
        }
        if (publisher instanceof Flux) {
            return (R)((Flux)publisher).subscriberContext(ContextUtils.acceptContext(ctx -> consumer.accept((Deque<String>)ctx.getOrDefault(ContextKey.of((String)this.name), LinkedList::new))));
        }
        return publisher;
    }

    @Override
    public <P extends Publisher<?>> P useLast(P publisher) {
        return this.doInContext(publisher, queue -> {
            if (queue.isEmpty()) {
                return;
            }
            queue.removeLast();
        });
    }

    @Override
    public <P extends Publisher<?>> P use(P publisher, String id) {
        return this.doInContext(publisher, queue -> queue.addLast(id));
    }

    @Override
    public <P extends Publisher<?>> P useDefault(P publisher) {
        return this.use(publisher, this.defaultId);
    }

    @Override
    public <P extends Publisher<?>> P reset(P publisher) {
        return this.doInContext(publisher, Collection::clear);
    }

    @Override
    public Mono<String> current() {
        return this.doInContext(queue -> {
            if (queue.isEmpty()) {
                return Mono.empty();
            }
            String activeId = (String)queue.getLast();
            if (this.defaultId.equals(activeId)) {
                return Mono.empty();
            }
            return Mono.just((Object)activeId);
        });
    }
}

