/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mousio.client.exceptions.PrematureDisconnectException;
import mousio.etcd4j.requests.EtcdRequest;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdResponseDecoder;
import mousio.etcd4j.transport.EtcdNettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdResponseHandler<R>
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdResponseHandler.class);
    private static final Map<HttpResponseStatus, EtcdResponseDecoder<? extends Throwable>> failureDecoders = new HashMap<HttpResponseStatus, EtcdResponseDecoder<? extends Throwable>>();
    protected final Promise<R> promise;
    protected final EtcdNettyClient client;
    protected final EtcdRequest<R> request;
    private boolean isRetried;

    public EtcdResponseHandler(EtcdNettyClient etcdNettyClient, EtcdRequest<R> etcdRequest) {
        this.client = etcdNettyClient;
        this.request = etcdRequest;
        this.promise = etcdRequest.getPromise().getNettyPromise();
        this.isRetried = false;
    }

    public void retried(boolean retried) {
        this.isRetried = retried;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (!this.isRetried && !this.promise.isDone()) {
            this.request.getPromise().handleRetry(new PrematureDisconnectException());
        }
        super.channelUnregistered(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        HttpResponseStatus status = response.status();
        HttpHeaders headers = response.headers();
        ByteBuf content = response.content();
        if (logger.isDebugEnabled()) {
            logger.debug("Received {} for {} {}", new Object[]{status.code(), this.request.getMethod().name(), this.request.getUri()});
        }
        if (status.equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) || status.equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT)) {
            if (headers.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                this.request.setUrl(headers.get((CharSequence)HttpHeaderNames.LOCATION));
                this.client.connect(this.request);
                ctx.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("redirect for {} to {}", (Object)this.request.getHttpRequest().uri(), (Object)headers.get((CharSequence)HttpHeaderNames.LOCATION));
                }
            } else {
                this.promise.setFailure((Throwable)new Exception("Missing Location header on redirect"));
            }
        } else {
            EtcdResponseDecoder<? extends Throwable> failureDecoder = failureDecoders.get(status);
            if (failureDecoder != null) {
                this.promise.setFailure(failureDecoder.decode(headers, content));
            } else if (!content.isReadable()) {
                if (!(status.equals((Object)HttpResponseStatus.OK) || status.equals((Object)HttpResponseStatus.ACCEPTED) || status.equals((Object)HttpResponseStatus.CREATED))) {
                    this.promise.setFailure((Throwable)new IOException("Content was not readable. HTTP Status: " + status));
                }
            } else {
                try {
                    this.promise.setSuccess(this.request.getResponseDecoder().decode(headers, content));
                }
                catch (Exception e) {
                    if (e instanceof EtcdException) {
                        this.promise.setFailure((Throwable)e);
                    }
                    try {
                        this.promise.setFailure((Throwable)EtcdException.DECODER.decode(headers, content));
                    }
                    catch (Exception e1) {
                        this.promise.setFailure((Throwable)e);
                    }
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.promise.setFailure(cause);
    }

    static {
        failureDecoders.put(HttpResponseStatus.UNAUTHORIZED, EtcdAuthenticationException.DECODER);
        failureDecoders.put(HttpResponseStatus.NOT_FOUND, EtcdException.DECODER);
        failureDecoders.put(HttpResponseStatus.FORBIDDEN, EtcdException.DECODER);
        failureDecoders.put(HttpResponseStatus.PRECONDITION_FAILED, EtcdException.DECODER);
        failureDecoders.put(HttpResponseStatus.INTERNAL_SERVER_ERROR, EtcdException.DECODER);
        failureDecoders.put(HttpResponseStatus.BAD_REQUEST, EtcdException.DECODER);
    }
}

