/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.noear.folkmq.broker.MqBorkerInternal;
import org.noear.folkmq.broker.MqQueue;
import org.noear.folkmq.broker.embedded.MqBrokerConfig;
import org.noear.folkmq.broker.embedded.admin.BaseController;
import org.noear.folkmq.broker.embedded.admin.dso.QueueForceService;
import org.noear.folkmq.broker.embedded.admin.dso.ViewUtils;
import org.noear.folkmq.broker.embedded.admin.model.QueueVo;
import org.noear.socketd.transport.core.Session;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.annotation.Logined;
import org.noear.solon.validation.annotation.NotEmpty;
import org.noear.solon.validation.annotation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Logined
@Valid
public class AdminQueueController
extends BaseController {
    static final Logger log = LoggerFactory.getLogger(AdminQueueController.class);
    @Inject
    private MqBorkerInternal server;
    @Inject
    private QueueForceService queueForceService;

    @Mapping(value="/admin/queue")
    public ModelAndView queue() {
        List<QueueVo> list = ViewUtils.queueView(this.server);
        return this.view("admin_queue").put("list", list);
    }

    @Mapping(value="/admin/queue_session")
    public ModelAndView queue_session(@NotEmpty String topic, @NotEmpty String consumerGroup) throws IOException {
        String queueName = topic + "#" + consumerGroup;
        ArrayList<String> list = new ArrayList<String>();
        MqQueue queue = this.server.getQueue(queueName);
        if (queue != null) {
            ArrayList sessions = new ArrayList(queue.sessionAll());
            for (Session s1 : sessions) {
                list.add(s1.remoteAddress().toString());
                if (list.size() != 99) continue;
                break;
            }
        }
        return this.view("admin_queue_session").put("list", list);
    }

    @Mapping(value="/admin/queue_details")
    public ModelAndView queue_details(@NotEmpty String topic, @NotEmpty String consumerGroup) throws IOException {
        String queueName = topic + "#" + consumerGroup;
        return this.view("admin_queue_details").put("topic", (Object)topic).put("consumerGroup", (Object)consumerGroup);
    }

    @Post
    @Mapping(value="/admin/queue_details/ajax/distribute")
    public Result queue_details_ajax_distribute(@NotEmpty String topic, @NotEmpty String consumerGroup) {
        return this.queueForceService.forceDistribute(this.server, topic, consumerGroup, MqBrokerConfig.isStandalone());
    }

    @Post
    @Mapping(value="/admin/queue_details/ajax/clear")
    public Result queue_details_ajax_clear(@NotEmpty String topic, @NotEmpty String consumerGroup) {
        return this.queueForceService.forceClear(this.server, topic, consumerGroup, MqBrokerConfig.isStandalone());
    }

    @Post
    @Mapping(value="/admin/queue_details/ajax/delete")
    public Result queue_details_ajax_delete(@NotEmpty String topic, @NotEmpty String consumerGroup) {
        return this.queueForceService.forceDelete(this.server, topic, consumerGroup, MqBrokerConfig.isStandalone());
    }
}

