/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded.admin.dso;

import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.folkmq.broker.MqBorkerInternal;
import org.noear.folkmq.broker.MqQueue;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.handle.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class QueueForceService {
    static final Logger log = LoggerFactory.getLogger(QueueForceService.class);
    static AtomicBoolean force_lock = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result forceDistribute(MqBorkerInternal server, String topic, String consumerGroup, boolean isStandalone) {
        if (force_lock.get()) {
            return Result.failure((String)"\u6b63\u5728\u8fdb\u884c\u522b\u7684\u5f3a\u5236\u64cd\u4f5c!");
        }
        try {
            force_lock.set(true);
            String queueName = topic + "#" + consumerGroup;
            log.warn("Queue forceDistribute: queueName={}", (Object)queueName);
            MqQueue queue = server.getQueue(queueName);
            if (queue != null) {
                if (queue.sessionCount() == 0 && isStandalone) {
                    Result result = Result.failure((String)"\u6ca1\u6709\u6d88\u8d39\u8005\u8fde\u63a5\uff0c\u4e0d\u80fd\u6d3e\u53d1!");
                    return result;
                }
                if (queue.messageTotal() == 0) {
                    Result result = Result.failure((String)"\u6ca1\u6709\u6d88\u606f\u53ef\u6d3e\u53d1!");
                    return result;
                }
                queue.forceDistribute(1, 0);
                Result result = Result.succeed();
                return result;
            }
            Result result = Result.failure((String)"\u6ca1\u6709\u627e\u5230\u961f\u5217!");
            return result;
        }
        finally {
            force_lock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result forceDelete(MqBorkerInternal server, String topic, String consumerGroup, boolean isStandalone) {
        if (force_lock.get()) {
            return Result.failure((String)"\u6b63\u5728\u8fdb\u884c\u522b\u7684\u5f3a\u5236\u64cd\u4f5c!");
        }
        try {
            force_lock.set(true);
            String queueName = topic + "#" + consumerGroup;
            log.warn("Queue forceDelete: queueName={}", (Object)queueName);
            MqQueue queue = server.getQueue(queueName);
            if (queue != null) {
                if (queue.sessionCount() > 0 && isStandalone) {
                    Result result = Result.failure((String)"\u6709\u6d88\u8d39\u8005\u8fde\u63a5\uff0c\u4e0d\u80fd\u5220\u9664!");
                    return result;
                }
                server.removeQueue(queueName);
                queue.forceClear();
                Result result = Result.succeed();
                return result;
            }
            Result result = Result.failure((String)"\u6ca1\u6709\u627e\u5230\u961f\u5217!");
            return result;
        }
        finally {
            force_lock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result forceClear(MqBorkerInternal server, String topic, String consumerGroup, boolean isStandalone) {
        if (force_lock.get()) {
            return Result.failure((String)"\u6b63\u5728\u8fdb\u884c\u522b\u7684\u5f3a\u5236\u64cd\u4f5c!");
        }
        try {
            force_lock.set(true);
            String queueName = topic + "#" + consumerGroup;
            log.warn("Queue forceClear: queueName={}", (Object)queueName);
            MqQueue queue = server.getQueue(queueName);
            if (queue != null) {
                if (queue.sessionCount() > 0 && isStandalone) {
                    Result result = Result.failure((String)"\u6709\u6d88\u8d39\u8005\u8fde\u63a5\uff0c\u4e0d\u80fd\u6e05\u7a7a!");
                    return result;
                }
                queue.forceClear();
                Result result = Result.succeed();
                return result;
            }
            Result result = Result.failure((String)"\u6ca1\u6709\u627e\u5230\u961f\u5217!");
            return result;
        }
        finally {
            force_lock.set(false);
        }
    }
}

