/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket;

import java.io.IOException;
import java.util.Map;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.java_websocket.WsNioChannelAssistant;
import org.noear.socketd.transport.java_websocket.impl.WebSocketServerImpl;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsNioServer
extends ServerBase<WsNioChannelAssistant>
implements ChannelSupporter<WebSocket> {
    private static final Logger log = LoggerFactory.getLogger(WsNioServer.class);
    private WebSocketServerImpl server;

    public WsNioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new WsNioChannelAssistant((Config)config));
    }

    public String getTitle() {
        return "ws/nio/java-websocket 1.5/" + SocketD.version();
    }

    public void onOpen(Session s) throws IOException {
        Map headerMap = (Map)s.attr("ws-handshake-headers");
        if (headerMap != null) {
            s.handshake().paramMap().putAll(headerMap);
            s.attrDel("ws-handshake-headers");
        }
        super.onOpen(s);
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.server = StrUtils.isEmpty((String)this.getConfig().getHost()) ? new WebSocketServerImpl(this.getConfig().getPort(), this) : new WebSocketServerImpl(this.getConfig().getHost(), this.getConfig().getPort(), this);
        if (this.getConfig().getSslContext() != null) {
            this.server.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(this.getConfig().getSslContext()));
        }
        if (this.getConfig().getIdleTimeout() > 0L) {
            this.server.setConnectionLostTimeout((int)(this.getConfig().getIdleTimeout() / 1000L));
        }
        this.server.setReuseAddr(true);
        this.server.start();
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        super.stop();
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.debug("Server stop error", (Throwable)e);
        }
    }
}

