/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.protocols.Protocol;
import org.java_websocket.server.WebSocketServer;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_websocket.WsNioChannelAssistant;
import org.noear.socketd.transport.java_websocket.WsNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerImpl
extends WebSocketServer {
    static final Logger log = LoggerFactory.getLogger(WebSocketServerImpl.class);
    public static final String WS_HANDSHAKE_HEADER = "ws-handshake-headers";
    private WsNioServer server;

    public WebSocketServerImpl(int port, WsNioServer server) {
        super(new InetSocketAddress(port), server.getConfig().getCodecThreads(), server.getConfig().isUseSubprotocols() ? Collections.singletonList(new Draft_6455(Collections.emptyList(), Arrays.asList(new Protocol(SocketD.protocolName())))) : Collections.singletonList(new Draft_6455(Collections.emptyList(), Arrays.asList(new Protocol(SocketD.protocolName()), new Protocol("")))));
        this.server = server;
    }

    public WebSocketServerImpl(String addr, int port, WsNioServer server) {
        super(new InetSocketAddress(addr, port), server.getConfig().getCodecThreads(), server.getConfig().isUseSubprotocols() ? Collections.singletonList(new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol(SocketD.protocolName())))) : null);
        this.server = server;
    }

    public void onWebsocketPing(WebSocket conn, Framedata f) {
        if (this.checkServerHandshake(conn)) {
            super.onWebsocketPing(conn, f);
        }
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        if (this.checkServerHandshake(conn)) {
            super.onWebsocketPong(conn, f);
        }
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        ChannelDefault channel = new ChannelDefault((Object)conn, (ChannelSupporter)this.server);
        conn.setAttachment((Object)channel);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Iterator httpFields = handshake.iterateHttpFields();
        while (httpFields.hasNext()) {
            String name = (String)httpFields.next();
            headerMap.put(name, handshake.getFieldValue(name));
        }
        channel.getSession().attrPut(WS_HANDSHAKE_HEADER, headerMap);
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        ChannelInternal channel = (ChannelInternal)conn.getAttachment();
        if (channel != null && channel.getHandshake() != null) {
            this.server.getProcessor().onClose(channel);
        }
    }

    public void onMessage(WebSocket conn, String message) {
        conn.close();
        if (log.isWarnEnabled()) {
            log.warn("Server channel unsupported onMessage(String test)");
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer message) {
        try {
            ((WebSocketImpl)conn).updateLastPong();
            ChannelInternal channel = (ChannelInternal)conn.getAttachment();
            Frame frame = ((WsNioChannelAssistant)this.server.getAssistant()).read(message);
            if (frame != null) {
                this.server.getProcessor().reveFrame(channel, frame);
            }
        }
        catch (Throwable e) {
            log.warn("WebSocket server onMessage error", e);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        try {
            ChannelInternal channel = (ChannelInternal)conn.getAttachment();
            if (channel != null) {
                this.server.getProcessor().onError(channel, (Throwable)ex);
            }
        }
        catch (Throwable e) {
            log.warn("WebSocket server onError error", e);
        }
    }

    public void onStart() {
        if (this.server.getConfig().getIdleTimeout() > 0L) {
            this.setConnectionLostTimeout((int)(this.server.getConfig().getIdleTimeout() / 1000L));
        } else {
            this.setConnectionLostTimeout(0);
        }
    }

    protected boolean checkServerHandshake(WebSocket conn) {
        ChannelInternal channel = (ChannelInternal)conn.getAttachment();
        return channel != null && channel.getHandshake() != null;
    }
}

