/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import org.noear.socketd.exception.SocketDException;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientChannel;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientConnectHandler;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.client.ClientHeartbeatHandler;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.client.impl.ClientConnectHandlerDefault;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase<T extends ChannelAssistant>
implements ClientInternal {
    private static final Logger log = LoggerFactory.getLogger(ClientBase.class);
    protected Processor processor = new ProcessorDefault();
    protected ClientHeartbeatHandler heartbeatHandler;
    protected ClientConnectHandler connectHandler = new ClientConnectHandlerDefault();
    private final ClientConfig config;
    private final T assistant;

    public ClientBase(ClientConfig config, T assistant) {
        this.config = config;
        this.assistant = assistant;
    }

    public T getAssistant() {
        return this.assistant;
    }

    @Override
    public ClientConfig getConfig() {
        return this.config;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public ClientConnectHandler getConnectHandler() {
        return this.connectHandler;
    }

    @Override
    public ClientHeartbeatHandler getHeartbeatHandler() {
        return this.heartbeatHandler;
    }

    @Override
    public long getHeartbeatInterval() {
        return this.config.getHeartbeatInterval();
    }

    @Override
    public Client connectHandler(ClientConnectHandler connectHandler) {
        if (connectHandler != null) {
            this.connectHandler = connectHandler;
        }
        return this;
    }

    @Override
    public Client heartbeatHandler(ClientHeartbeatHandler heartbeatHandler) {
        if (heartbeatHandler != null) {
            this.heartbeatHandler = heartbeatHandler;
        }
        return this;
    }

    @Override
    public Client config(ClientConfigHandler configHandler) {
        if (configHandler != null) {
            configHandler.clientConfig(this.config);
        }
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        if (listener != null) {
            this.processor.setListener(listener);
        }
        return this;
    }

    @Override
    public ClientSession open() {
        try {
            return this.openDo(false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ClientSession openOrThow() throws IOException {
        return this.openDo(true);
    }

    private Session openDo(boolean isThow) throws IOException {
        ClientConnector connector = this.createConnector();
        ClientChannel clientChannel = new ClientChannel(this, connector);
        try {
            clientChannel.connect();
            log.info("Socket.D client successfully connected: {link={}}", (Object)this.getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            if (isThow) {
                clientChannel.close(2008);
                if (e instanceof RuntimeException || e instanceof IOException) {
                    throw e;
                }
                throw new SocketDException("Socket.D client Connection failed", e);
            }
            log.info("Socket.D client Connection failed: {link={}}", (Object)this.getConfig().getLinkUrl());
        }
        return clientChannel.getSession();
    }

    protected abstract ClientConnector createConnector();
}

