/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.entity;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.UnmapUtil;

public class TempfileEntity
extends EntityDefault {
    private final File file;
    private final FileChannel fileC;
    private RandomAccessFile fileRaf;

    public TempfileEntity(File file, FileChannel fileC, ByteBuffer data, Map<String, String> metaMap) throws IOException {
        this.file = file;
        this.fileC = fileC;
        this.dataSet(data);
        this.metaMapPut(metaMap);
    }

    public TempfileEntity(File file) throws IOException {
        this.file = file;
        this.fileRaf = new RandomAccessFile(file, "r");
        this.fileC = this.fileRaf.getChannel();
        long len = file.length();
        MappedByteBuffer byteBuffer = this.fileC.map(FileChannel.MapMode.READ_ONLY, 0L, len);
        this.dataSet(byteBuffer);
        this.metaPut("Data-Disposition-Filename", file.getName());
    }

    @Override
    public void release() throws IOException {
        if (this.data() instanceof MappedByteBuffer) {
            UnmapUtil.unmap(this.fileC, (MappedByteBuffer)this.data());
        }
        if (this.fileRaf != null) {
            this.fileRaf.close();
        }
        this.file.delete();
    }
}

