/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.stream.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.stream.StreamInternal;
import org.noear.socketd.transport.stream.StreamManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMangerDefault
implements StreamManger {
    private static Logger log = LoggerFactory.getLogger(ChannelDefault.class);
    private final Config config;
    private final Map<String, StreamInternal> streamMap = new ConcurrentHashMap<String, StreamInternal>();

    public StreamMangerDefault(Config config) {
        this.config = config;
    }

    @Override
    public StreamInternal getStream(String sid) {
        return this.streamMap.get(sid);
    }

    @Override
    public void addStream(String sid, StreamInternal stream) {
        long streamTimeout;
        Asserts.assertNull("stream", stream);
        if (stream.demands() == 0) {
            return;
        }
        this.streamMap.put(sid, stream);
        long l = streamTimeout = stream.timeout() > 0L ? stream.timeout() : this.config.getStreamTimeout();
        if (streamTimeout > 0L) {
            stream.insuranceStart(this, streamTimeout);
        }
    }

    @Override
    public void removeStream(String sid) {
        StreamInternal stream = this.streamMap.remove(sid);
        if (stream != null) {
            stream.insuranceCancel();
            if (log.isDebugEnabled()) {
                log.debug("{} stream removed, sid={}", (Object)this.config.getRoleName(), (Object)sid);
            }
        }
    }
}

