/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.lang.reflect.Method;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.util.UriUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class DomainClassResolver {
    @NonNull
    private final Repositories repositories;
    @NonNull
    private final ResourceMappings mappings;
    @NonNull
    private final BaseUri baseUri;

    public Class<?> resolve(Method method, NativeWebRequest webRequest) {
        List<String> pathSegments;
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)webRequest, (String)"NativeWebRequest must not be null!");
        String lookupPath = this.baseUri.getRepositoryLookupPath(webRequest);
        String repositoryKey = UriUtils.findMappingVariable("repository", method, lookupPath);
        if (!StringUtils.hasText((String)repositoryKey) && !(pathSegments = UriUtils.getPathSegments(method)).isEmpty()) {
            repositoryKey = pathSegments.get(0);
        }
        if (!StringUtils.hasText((String)repositoryKey)) {
            return null;
        }
        for (Class domainType : this.repositories) {
            ResourceMetadata mapping = this.mappings.getMetadataFor(domainType);
            if (!mapping.getPath().matches(repositoryKey) || !mapping.isExported()) continue;
            return domainType;
        }
        return null;
    }

    private DomainClassResolver(@NonNull Repositories repositories, @NonNull ResourceMappings mappings, @NonNull BaseUri baseUri) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is marked non-null but is null");
        }
        if (mappings == null) {
            throw new IllegalArgumentException("mappings is marked non-null but is null");
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is marked non-null but is null");
        }
        this.repositories = repositories;
        this.mappings = mappings;
        this.baseUri = baseUri;
    }

    public static DomainClassResolver of(@NonNull Repositories repositories, @NonNull ResourceMappings mappings, @NonNull BaseUri baseUri) {
        return new DomainClassResolver(repositories, mappings, baseUri);
    }
}

