/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpSocketFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TcpNetServerConnectionFactory
extends AbstractServerConnectionFactory {
    private volatile ServerSocket serverSocket;
    private volatile TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();
    private TcpNetConnectionSupport tcpNetConnectionSupport = new DefaultTcpNetConnectionSupport();

    public TcpNetServerConnectionFactory(int port) {
        super(port);
    }

    public String getComponentType() {
        return "tcp-net-server-connection-factory";
    }

    @Override
    public int getPort() {
        int port = super.getPort();
        ServerSocket socket = this.serverSocket;
        if (port == 0 && socket != null) {
            port = socket.getLocalPort();
        }
        return port;
    }

    @Override
    @Nullable
    public SocketAddress getServerSocketAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalSocketAddress();
        }
        return null;
    }

    public void setTcpNetConnectionSupport(TcpNetConnectionSupport connectionSupport) {
        Assert.notNull((Object)connectionSupport, (String)"'connectionSupport' cannot be null");
        this.tcpNetConnectionSupport = connectionSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServerSocket theServerSocket = null;
        if (this.getListener() == null) {
            this.logger.info((Object)(this + " No listener bound to server connection factory; will not read; exiting..."));
            return;
        }
        try {
            try {
                if (this.getLocalAddress() == null) {
                    theServerSocket = this.createServerSocket(super.getPort(), this.getBacklog(), null);
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.getLocalAddress());
                    theServerSocket = this.createServerSocket(super.getPort(), this.getBacklog(), whichNic);
                }
                this.getTcpSocketSupport().postProcessServerSocket(theServerSocket);
                this.serverSocket = theServerSocket;
                this.setListening(true);
                this.logger.info((Object)(this + " Listening"));
                this.publishServerListeningEvent(this.getPort());
                while (true) {
                    Socket socket;
                    try {
                        if (this.serverSocket == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)(this + " stopped before accept"));
                            }
                            throw new IOException(this + " stopped before accept");
                        }
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException ste) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)"Timed out on accept; continuing");
                        continue;
                    }
                    if (this.isShuttingDown()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("New connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + " rejected; the server is in the process of shutting down."));
                        }
                        socket.close();
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Accepted connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort()));
                    }
                    try {
                        this.setSocketAttributes(socket);
                        TcpConnectionSupport connection = this.tcpNetConnectionSupport.createNewConnection(socket, true, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
                        connection = this.wrapConnection(connection);
                        this.initializeConnection(connection, socket);
                        this.getTaskExecutor().execute(connection);
                        this.harvestClosedConnections();
                        connection.publishConnectionOpenEvent();
                    }
                    catch (RuntimeException e) {
                        this.logger.error((Object)("Failed to create and configure a TcpConnection for the new socket: " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort()), (Throwable)e);
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof SocketException && theServerSocket != null) {
                    this.logger.info((Object)"Server Socket closed");
                } else if (this.isActive()) {
                    this.logger.error((Object)("Error on ServerSocket; port = " + this.getPort()), (Throwable)e);
                    this.publishServerExceptionEvent(e);
                    this.stop();
                }
                this.setListening(false);
                this.setActive(false);
            }
        }
        catch (Throwable throwable) {
            this.setListening(false);
            this.setActive(false);
            throw throwable;
        }
    }

    protected ServerSocket createServerSocket(int port, int backlog, @Nullable InetAddress whichNic) throws IOException {
        ServerSocketFactory serverSocketFactory = this.tcpSocketFactorySupport.getServerSocketFactory();
        if (whichNic == null) {
            return serverSocketFactory.createServerSocket(port, Math.abs(backlog));
        }
        return serverSocketFactory.createServerSocket(port, Math.abs(backlog), whichNic);
    }

    @Override
    public void stop() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        super.stop();
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }
}

